#ifndef CUFFTDX_FFT_125_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_125_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<361, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1369>;
.reg .b32 r<14>;
.reg .b64 rd<9>;
mov.u32 r12, %tid.y;
mov.u32 r13, %50;
mad.lo.s32 r3, r12, 1000, r13;
add.f32 f101, %62, %92;
add.f32 f103, %72, %82;
add.f32 f1368, %52, f101;
add.f32 f104, f103, f1368;
add.f32 f105, %102, %104;
add.f32 f107, %103, %83;
add.f32 f1364, %53, f105;
add.f32 f108, f107, f1364;
mul.f32 f110, f103, 0f3F4F1BBD;
fma.rn.f32 f1363, f101, 0f3E9E377A, %52;
sub.f32 f111, f1363, f110;
sub.f32 f112, %102, %104;
sub.f32 f114, %103, %83;
mul.f32 f1362, f112, 0f3F737871;
fma.rn.f32 f115, f114, 0f3F167918, f1362;
sub.f32 f116, f111, f115;
add.f32 f117, f115, f111;
mul.f32 f118, f101, 0f3F4F1BBD;
sub.f32 f119, %52, f118;
fma.rn.f32 f120, f103, 0f3E9E377A, f119;
mul.f32 f121, f112, 0f3F167918;
mul.f32 f122, f114, 0f3F737871;
sub.f32 f123, f121, f122;
sub.f32 f124, f120, f123;
add.f32 f125, f123, f120;
mul.f32 f127, f107, 0f3F4F1BBD;
fma.rn.f32 f1361, f105, 0f3E9E377A, %53;
sub.f32 f128, f1361, f127;
sub.f32 f129, %62, %92;
sub.f32 f131, %72, %82;
mul.f32 f1360, f129, 0f3F737871;
fma.rn.f32 f132, f131, 0f3F167918, f1360;
add.f32 f133, f132, f128;
sub.f32 f134, f128, f132;
mul.f32 f135, f105, 0f3F4F1BBD;
sub.f32 f136, %53, f135;
fma.rn.f32 f137, f107, 0f3E9E377A, f136;
mul.f32 f138, f129, 0f3F167918;
mul.f32 f139, f131, 0f3F737871;
sub.f32 f140, f138, f139;
add.f32 f141, f140, f137;
sub.f32 f142, f137, f140;
add.f32 f143, %64, %94;
add.f32 f145, %74, %84;
add.f32 f1359, %54, f143;
add.f32 f146, f145, f1359;
add.f32 f147, %65, %95;
add.f32 f149, %107, %105;
add.f32 f1355, %106, f147;
add.f32 f150, f149, f1355;
fma.rn.f32 f1353, f143, 0f3E9E377A, %54;
mul.f32 f1354, f145, 0f3F4F1BBD;
sub.f32 f153, f1353, f1354;
sub.f32 f154, %65, %95;
sub.f32 f156, %107, %105;
mul.f32 f1352, f154, 0f3F737871;
fma.rn.f32 f157, f156, 0f3F167918, f1352;
sub.f32 f158, f153, f157;
add.f32 f159, f157, f153;
mul.f32 f160, f143, 0f3F4F1BBD;
sub.f32 f161, %54, f160;
fma.rn.f32 f162, f145, 0f3E9E377A, f161;
mul.f32 f163, f154, 0f3F167918;
mul.f32 f164, f156, 0f3F737871;
sub.f32 f165, f163, f164;
sub.f32 f166, f162, f165;
add.f32 f167, f165, f162;
mul.f32 f169, f149, 0f3F4F1BBD;
fma.rn.f32 f1351, f147, 0f3E9E377A, %106;
sub.f32 f170, f1351, f169;
sub.f32 f171, %64, %94;
sub.f32 f173, %74, %84;
mul.f32 f1350, f171, 0f3F737871;
fma.rn.f32 f174, f173, 0f3F167918, f1350;
add.f32 f175, f174, f170;
sub.f32 f176, f170, f174;
mul.f32 f177, f147, 0f3F4F1BBD;
sub.f32 f178, %106, f177;
fma.rn.f32 f179, f149, 0f3E9E377A, f178;
mul.f32 f180, f171, 0f3F167918;
mul.f32 f181, f173, 0f3F737871;
sub.f32 f182, f180, f181;
add.f32 f183, f182, f179;
sub.f32 f184, f179, f182;
add.f32 f185, %66, %96;
add.f32 f187, %76, %86;
add.f32 f1349, %56, f185;
add.f32 f188, f187, f1349;
add.f32 f189, %110, %109;
add.f32 f191, %77, %111;
add.f32 f1344, %108, f189;
add.f32 f192, f191, f1344;
fma.rn.f32 f1342, f185, 0f3E9E377A, %56;
mul.f32 f1343, f187, 0f3F4F1BBD;
sub.f32 f195, f1342, f1343;
sub.f32 f196, %110, %109;
sub.f32 f198, %77, %111;
mul.f32 f1341, f196, 0f3F737871;
fma.rn.f32 f199, f198, 0f3F167918, f1341;
sub.f32 f200, f195, f199;
add.f32 f201, f199, f195;
mul.f32 f202, f185, 0f3F4F1BBD;
sub.f32 f203, %56, f202;
fma.rn.f32 f204, f187, 0f3E9E377A, f203;
mul.f32 f205, f196, 0f3F167918;
mul.f32 f206, f198, 0f3F737871;
sub.f32 f207, f205, f206;
sub.f32 f208, f204, f207;
add.f32 f209, f207, f204;
fma.rn.f32 f1339, f189, 0f3E9E377A, %108;
mul.f32 f1340, f191, 0f3F4F1BBD;
sub.f32 f212, f1339, f1340;
sub.f32 f213, %66, %96;
sub.f32 f215, %76, %86;
mul.f32 f1338, f213, 0f3F737871;
fma.rn.f32 f216, f215, 0f3F167918, f1338;
add.f32 f217, f216, f212;
sub.f32 f218, f212, f216;
mul.f32 f219, f189, 0f3F4F1BBD;
sub.f32 f220, %108, f219;
fma.rn.f32 f221, f191, 0f3E9E377A, f220;
mul.f32 f222, f213, 0f3F167918;
mul.f32 f223, f215, 0f3F737871;
sub.f32 f224, f222, f223;
add.f32 f225, f224, f221;
sub.f32 f226, f221, f224;
add.f32 f227, %68, %98;
add.f32 f229, %78, %88;
add.f32 f1337, %58, f227;
add.f32 f230, f229, f1337;
add.f32 f231, %112, %114;
add.f32 f233, %113, %89;
add.f32 f1333, %59, f231;
add.f32 f234, f233, f1333;
mul.f32 f236, f229, 0f3F4F1BBD;
fma.rn.f32 f1332, f227, 0f3E9E377A, %58;
sub.f32 f237, f1332, f236;
sub.f32 f238, %112, %114;
sub.f32 f240, %113, %89;
mul.f32 f1331, f238, 0f3F737871;
fma.rn.f32 f241, f240, 0f3F167918, f1331;
sub.f32 f242, f237, f241;
add.f32 f243, f241, f237;
mul.f32 f244, f227, 0f3F4F1BBD;
sub.f32 f245, %58, f244;
fma.rn.f32 f246, f229, 0f3E9E377A, f245;
mul.f32 f247, f238, 0f3F167918;
mul.f32 f248, f240, 0f3F737871;
sub.f32 f249, f247, f248;
sub.f32 f250, f246, f249;
add.f32 f251, f249, f246;
mul.f32 f253, f233, 0f3F4F1BBD;
fma.rn.f32 f1330, f231, 0f3E9E377A, %59;
sub.f32 f254, f1330, f253;
sub.f32 f255, %68, %98;
sub.f32 f257, %78, %88;
mul.f32 f1329, f255, 0f3F737871;
fma.rn.f32 f258, f257, 0f3F167918, f1329;
add.f32 f259, f258, f254;
sub.f32 f260, f254, f258;
mul.f32 f261, f231, 0f3F4F1BBD;
sub.f32 f262, %59, f261;
fma.rn.f32 f263, f233, 0f3E9E377A, f262;
mul.f32 f264, f255, 0f3F167918;
mul.f32 f265, f257, 0f3F737871;
sub.f32 f266, f264, f265;
add.f32 f267, f266, f263;
sub.f32 f268, f263, f266;
add.f32 f269, %70, %100;
add.f32 f271, %80, %90;
add.f32 f1328, %60, f269;
add.f32 f272, f271, f1328;
add.f32 f273, %71, %101;
add.f32 f275, %116, %117;
add.f32 f1324, %115, f273;
add.f32 f276, f275, f1324;
mul.f32 f278, f271, 0f3F4F1BBD;
fma.rn.f32 f1323, f269, 0f3E9E377A, %60;
sub.f32 f279, f1323, f278;
sub.f32 f280, %71, %101;
sub.f32 f282, %116, %117;
mul.f32 f1322, f280, 0f3F737871;
fma.rn.f32 f283, f282, 0f3F167918, f1322;
sub.f32 f284, f279, f283;
add.f32 f285, f283, f279;
mul.f32 f286, f269, 0f3F4F1BBD;
sub.f32 f287, %60, f286;
fma.rn.f32 f288, f271, 0f3E9E377A, f287;
mul.f32 f289, f280, 0f3F167918;
mul.f32 f290, f282, 0f3F737871;
sub.f32 f291, f289, f290;
sub.f32 f292, f288, f291;
add.f32 f293, f291, f288;
mul.f32 f295, f275, 0f3F4F1BBD;
fma.rn.f32 f1321, f273, 0f3E9E377A, %115;
sub.f32 f296, f1321, f295;
sub.f32 f297, %70, %100;
sub.f32 f299, %80, %90;
mul.f32 f1320, f297, 0f3F737871;
fma.rn.f32 f300, f299, 0f3F167918, f1320;
add.f32 f301, f300, f296;
sub.f32 f302, f296, f300;
mul.f32 f303, f273, 0f3F4F1BBD;
sub.f32 f304, %115, f303;
fma.rn.f32 f305, f275, 0f3E9E377A, f304;
mul.f32 f306, f297, 0f3F167918;
mul.f32 f307, f299, 0f3F737871;
sub.f32 f308, f306, f307;
add.f32 f309, f308, f305;
sub.f32 f310, f305, f308;
mul.f32 f1318, f158, 0f3F77F511;
mul.f32 f1319, f175, 0f3E7EA890;
sub.f32 f313, f1318, f1319;
mul.f32 f314, f175, 0f3F77F511;
fma.rn.f32 f315, f158, 0f3E7EA890, f314;
mul.f32 f1316, f200, 0f3F6055A2;
mul.f32 f1317, f217, 0f3EF6A86B;
sub.f32 f318, f1316, f1317;
mul.f32 f319, f217, 0f3F6055A2;
fma.rn.f32 f320, f200, 0f3EF6A86B, f319;
mul.f32 f322, f259, 0f3F2F3E7B;
mul.f32 f1315, f242, 0f3F3A9DB0;
sub.f32 f323, f1315, f322;
mul.f32 f324, f259, 0f3F3A9DB0;
fma.rn.f32 f325, f242, 0f3F2F3E7B, f324;
mul.f32 f327, f301, 0f3F5825E0;
mul.f32 f1314, f284, 0f3F092BF2;
sub.f32 f328, f1314, f327;
mul.f32 f329, f301, 0f3F092BF2;
fma.rn.f32 f330, f284, 0f3F5825E0, f329;
mul.f32 f332, f183, 0f3EF6A86B;
mul.f32 f1313, f166, 0f3F6055A2;
sub.f32 f333, f1313, f332;
mul.f32 f334, f183, 0f3F6055A2;
fma.rn.f32 f335, f166, 0f3EF6A86B, f334;
mul.f32 f337, f225, 0f3F5825E0;
mul.f32 f1312, f208, 0f3F092BF2;
sub.f32 f338, f1312, f337;
mul.f32 f339, f225, 0f3F092BF2;
fma.rn.f32 f340, f208, 0f3F5825E0, f339;
mul.f32 f342, f267, 0f3F7F7EAE;
mul.f32 f1311, f250, 0f3D809851;
sub.f32 f343, f1311, f342;
mul.f32 f344, f267, 0f3D809851;
fma.rn.f32 f345, f250, 0f3F7F7EAE, f344;
mul.f32 f1309, f292, 0fBED9FFBE;
mul.f32 f1310, f309, 0f3F67A2BF;
sub.f32 f348, f1309, f1310;
mul.f32 f349, f309, 0fBED9FFBE;
fma.rn.f32 f350, f292, 0f3F67A2BF, f349;
mul.f32 f1307, f167, 0f3F3A9DB0;
mul.f32 f1308, f184, 0f3F2F3E7B;
sub.f32 f353, f1307, f1308;
mul.f32 f354, f184, 0f3F3A9DB0;
fma.rn.f32 f355, f167, 0f3F2F3E7B, f354;
mul.f32 f1305, f209, 0f3D809851;
mul.f32 f1306, f226, 0f3F7F7EAE;
sub.f32 f358, f1305, f1306;
mul.f32 f359, f226, 0f3D809851;
fma.rn.f32 f360, f209, 0f3F7F7EAE, f359;
mul.f32 f1303, f251, 0fBF232E38;
mul.f32 f1304, f268, 0f3F45405B;
sub.f32 f363, f1303, f1304;
mul.f32 f364, f268, 0fBF232E38;
fma.rn.f32 f365, f251, 0f3F45405B, f364;
mul.f32 f367, f310, 0f3E00575B;
mul.f32 f1302, f293, 0fBF7DFB3B;
sub.f32 f368, f1302, f367;
mul.f32 f369, f310, 0fBF7DFB3B;
fma.rn.f32 f370, f293, 0f3E00575B, f369;
mul.f32 f372, f176, 0f3F5825E0;
mul.f32 f1301, f159, 0f3F092BF2;
sub.f32 f373, f1301, f372;
mul.f32 f374, f176, 0f3F092BF2;
fma.rn.f32 f375, f159, 0f3F5825E0, f374;
mul.f32 f377, f218, 0f3F67A2BF;
mul.f32 f1300, f201, 0fBED9FFBE;
sub.f32 f378, f1300, f377;
mul.f32 f379, f218, 0fBED9FFBE;
fma.rn.f32 f380, f201, 0f3F67A2BF, f379;
mul.f32 f382, f260, 0f3E00575B;
mul.f32 f1299, f243, 0fBF7DFB3B;
sub.f32 f383, f1299, f382;
mul.f32 f384, f260, 0fBF7DFB3B;
fma.rn.f32 f385, f243, 0f3E00575B, f384;
mul.f32 f387, f302, 0fBF45405B;
mul.f32 f1298, f285, 0fBF232E38;
sub.f32 f388, f1298, f387;
mul.f32 f389, f302, 0fBF232E38;
fma.rn.f32 f390, f285, 0fBF45405B, f389;
add.f32 f391, f146, f272;
add.f32 f393, f188, f230;
mul.f32 f398, f393, 0f3F4F1BBD;
fma.rn.f32 f1297, f391, 0f3E9E377A, f104;
sub.f32 f399, f1297, f398;
add.f32 f1296, f150, f276;
sub.f32 f400, f150, f276;
add.f32 f1295, f192, f234;
sub.f32 f402, f192, f234;
mul.f32 f1294, f400, 0f3F737871;
fma.rn.f32 f403, f402, 0f3F167918, f1294;
sub.f32 f404, f399, f403;
add.f32 f405, f403, f399;
add.f32 f1293, f104, f391;
mul.f32 f406, f391, 0f3F4F1BBD;
sub.f32 f407, f104, f406;
fma.rn.f32 f408, f393, 0f3E9E377A, f407;
mul.f32 f409, f400, 0f3F167918;
mul.f32 f410, f402, 0f3F737871;
sub.f32 f411, f409, f410;
sub.f32 f412, f408, f411;
add.f32 f413, f411, f408;
mul.f32 f415, f1295, 0f3F4F1BBD;
fma.rn.f32 f1292, f1296, 0f3E9E377A, f108;
sub.f32 f416, f1292, f415;
sub.f32 f417, f146, f272;
sub.f32 f419, f188, f230;
mul.f32 f1291, f417, 0f3F737871;
fma.rn.f32 f420, f419, 0f3F167918, f1291;
add.f32 f421, f420, f416;
sub.f32 f422, f416, f420;
add.f32 f1290, f108, f1296;
mul.f32 f423, f1296, 0f3F4F1BBD;
sub.f32 f424, f108, f423;
fma.rn.f32 f425, f1295, 0f3E9E377A, f424;
mul.f32 f426, f417, 0f3F167918;
mul.f32 f427, f419, 0f3F737871;
sub.f32 f428, f426, f427;
add.f32 f429, f428, f425;
sub.f32 f430, f425, f428;
add.f32 f431, f313, f328;
add.f32 f433, f318, f323;
add.f32 f1289, f116, f431;
add.f32 f434, f433, f1289;
add.f32 f435, f315, f330;
add.f32 f437, f320, f325;
add.f32 f1288, f133, f435;
add.f32 f438, f437, f1288;
fma.rn.f32 f1286, f431, 0f3E9E377A, f116;
mul.f32 f1287, f433, 0f3F4F1BBD;
sub.f32 f441, f1286, f1287;
sub.f32 f442, f315, f330;
sub.f32 f444, f320, f325;
mul.f32 f1285, f442, 0f3F737871;
fma.rn.f32 f445, f444, 0f3F167918, f1285;
sub.f32 f446, f441, f445;
add.f32 f447, f445, f441;
mul.f32 f448, f431, 0f3F4F1BBD;
sub.f32 f449, f116, f448;
fma.rn.f32 f450, f433, 0f3E9E377A, f449;
mul.f32 f451, f442, 0f3F167918;
mul.f32 f452, f444, 0f3F737871;
sub.f32 f453, f451, f452;
sub.f32 f454, f450, f453;
add.f32 f455, f453, f450;
mul.f32 f457, f437, 0f3F4F1BBD;
fma.rn.f32 f1284, f435, 0f3E9E377A, f133;
sub.f32 f458, f1284, f457;
sub.f32 f459, f313, f328;
sub.f32 f461, f318, f323;
mul.f32 f1283, f459, 0f3F737871;
fma.rn.f32 f462, f461, 0f3F167918, f1283;
add.f32 f463, f462, f458;
sub.f32 f464, f458, f462;
mul.f32 f465, f435, 0f3F4F1BBD;
sub.f32 f466, f133, f465;
fma.rn.f32 f467, f437, 0f3E9E377A, f466;
mul.f32 f468, f459, 0f3F167918;
mul.f32 f469, f461, 0f3F737871;
sub.f32 f470, f468, f469;
add.f32 f471, f470, f467;
sub.f32 f472, f467, f470;
add.f32 f473, f333, f348;
add.f32 f475, f338, f343;
add.f32 f1282, f124, f473;
add.f32 f476, f475, f1282;
add.f32 f477, f335, f350;
add.f32 f479, f340, f345;
add.f32 f1281, f141, f477;
add.f32 f480, f479, f1281;
fma.rn.f32 f1279, f473, 0f3E9E377A, f124;
mul.f32 f1280, f475, 0f3F4F1BBD;
sub.f32 f483, f1279, f1280;
sub.f32 f484, f335, f350;
sub.f32 f486, f340, f345;
mul.f32 f1278, f484, 0f3F737871;
fma.rn.f32 f487, f486, 0f3F167918, f1278;
sub.f32 f488, f483, f487;
add.f32 f489, f487, f483;
mul.f32 f490, f473, 0f3F4F1BBD;
sub.f32 f491, f124, f490;
fma.rn.f32 f492, f475, 0f3E9E377A, f491;
mul.f32 f493, f484, 0f3F167918;
mul.f32 f494, f486, 0f3F737871;
sub.f32 f495, f493, f494;
sub.f32 f496, f492, f495;
add.f32 f497, f495, f492;
fma.rn.f32 f1276, f477, 0f3E9E377A, f141;
mul.f32 f1277, f479, 0f3F4F1BBD;
sub.f32 f500, f1276, f1277;
sub.f32 f501, f333, f348;
sub.f32 f503, f338, f343;
mul.f32 f1275, f501, 0f3F737871;
fma.rn.f32 f504, f503, 0f3F167918, f1275;
add.f32 f505, f504, f500;
sub.f32 f506, f500, f504;
mul.f32 f507, f477, 0f3F4F1BBD;
sub.f32 f508, f141, f507;
fma.rn.f32 f509, f479, 0f3E9E377A, f508;
mul.f32 f510, f501, 0f3F167918;
mul.f32 f511, f503, 0f3F737871;
sub.f32 f512, f510, f511;
add.f32 f513, f512, f509;
sub.f32 f514, f509, f512;
add.f32 f515, f353, f368;
add.f32 f517, f358, f363;
add.f32 f1274, f125, f515;
add.f32 f518, f517, f1274;
add.f32 f519, f355, f370;
add.f32 f521, f360, f365;
add.f32 f1273, f142, f519;
add.f32 f522, f521, f1273;
mul.f32 f524, f517, 0f3F4F1BBD;
fma.rn.f32 f1272, f515, 0f3E9E377A, f125;
sub.f32 f525, f1272, f524;
sub.f32 f526, f355, f370;
sub.f32 f528, f360, f365;
mul.f32 f1271, f526, 0f3F737871;
fma.rn.f32 f529, f528, 0f3F167918, f1271;
sub.f32 f530, f525, f529;
add.f32 f531, f529, f525;
mul.f32 f532, f515, 0f3F4F1BBD;
sub.f32 f533, f125, f532;
fma.rn.f32 f534, f517, 0f3E9E377A, f533;
mul.f32 f535, f526, 0f3F167918;
mul.f32 f536, f528, 0f3F737871;
sub.f32 f537, f535, f536;
sub.f32 f538, f534, f537;
add.f32 f539, f537, f534;
mul.f32 f541, f521, 0f3F4F1BBD;
fma.rn.f32 f1270, f519, 0f3E9E377A, f142;
sub.f32 f542, f1270, f541;
sub.f32 f543, f353, f368;
sub.f32 f545, f358, f363;
mul.f32 f1269, f543, 0f3F737871;
fma.rn.f32 f546, f545, 0f3F167918, f1269;
add.f32 f547, f546, f542;
sub.f32 f548, f542, f546;
mul.f32 f549, f519, 0f3F4F1BBD;
sub.f32 f550, f142, f549;
fma.rn.f32 f551, f521, 0f3E9E377A, f550;
mul.f32 f552, f543, 0f3F167918;
mul.f32 f553, f545, 0f3F737871;
sub.f32 f554, f552, f553;
add.f32 f555, f554, f551;
sub.f32 f556, f551, f554;
add.f32 f557, f373, f388;
add.f32 f559, f378, f383;
add.f32 f1268, f117, f557;
add.f32 f560, f559, f1268;
add.f32 f561, f375, f390;
add.f32 f563, f380, f385;
add.f32 f1267, f134, f561;
add.f32 f564, f563, f1267;
mul.f32 f566, f559, 0f3F4F1BBD;
fma.rn.f32 f1266, f557, 0f3E9E377A, f117;
sub.f32 f567, f1266, f566;
sub.f32 f568, f375, f390;
sub.f32 f570, f380, f385;
mul.f32 f1265, f568, 0f3F737871;
fma.rn.f32 f571, f570, 0f3F167918, f1265;
sub.f32 f572, f567, f571;
add.f32 f573, f571, f567;
mul.f32 f574, f557, 0f3F4F1BBD;
sub.f32 f575, f117, f574;
fma.rn.f32 f576, f559, 0f3E9E377A, f575;
mul.f32 f577, f568, 0f3F167918;
mul.f32 f578, f570, 0f3F737871;
sub.f32 f579, f577, f578;
sub.f32 f580, f576, f579;
add.f32 f581, f579, f576;
mul.f32 f583, f563, 0f3F4F1BBD;
fma.rn.f32 f1264, f561, 0f3E9E377A, f134;
sub.f32 f584, f1264, f583;
sub.f32 f585, f373, f388;
sub.f32 f587, f378, f383;
mul.f32 f1263, f585, 0f3F737871;
fma.rn.f32 f588, f587, 0f3F167918, f1263;
add.f32 f589, f588, f584;
sub.f32 f590, f584, f588;
mul.f32 f591, f561, 0f3F4F1BBD;
sub.f32 f592, f134, f591;
fma.rn.f32 f593, f563, 0f3E9E377A, f592;
mul.f32 f594, f585, 0f3F167918;
mul.f32 f595, f587, 0f3F737871;
sub.f32 f596, f594, f595;
add.f32 f597, f596, f593;
sub.f32 f598, f593, f596;
mov.u32 r11, %tid.x;
mul.wide.u32 rd2, r11, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r11, r6;
mad.lo.s32 r8, r5, 1000, r3;
mul.wide.u32 rd7, r7, 8;
mov.u64 rd8, %51;
add.s64 rd6, rd8, rd7;
ld.global.v2.f32 {f599, f600}, [rd6];
mul.f32 f603, f438, f600;
mul.f32 f605, f599, f438;
mul.f32 f607, f600, f600;
mul.f32 f1262, f599, f599;
sub.f32 f608, f1262, f607;
mul.f32 f609, f600, f599;
fma.rn.f32 f610, f600, f599, f609;
mul.f32 f611, f480, f610;
mul.f32 f613, f608, f480;
mul.f32 f615, f600, f610;
mul.f32 f1261, f599, f608;
sub.f32 f616, f1261, f615;
mul.f32 f1260, f476, f610;
mul.f32 f617, f599, f610;
fma.rn.f32 f618, f600, f608, f617;
mul.f32 f619, f522, f618;
mul.f32 f621, f616, f522;
mul.f32 f1258, f599, f616;
mul.f32 f1259, f600, f618;
sub.f32 f624, f1258, f1259;
mul.f32 f1257, f518, f618;
mul.f32 f625, f599, f618;
fma.rn.f32 f626, f600, f616, f625;
mul.f32 f627, f564, f626;
mul.f32 f629, f624, f564;
mul.f32 f631, f600, f626;
mul.f32 f1256, f599, f624;
sub.f32 f632, f1256, f631;
mul.f32 f1255, f560, f626;
mul.f32 f633, f599, f626;
fma.rn.f32 f634, f600, f624, f633;
mul.f32 f635, f421, f634;
mul.f32 f637, f632, f421;
mul.f32 f1253, f599, f632;
mul.f32 f1254, f600, f634;
sub.f32 f640, f1253, f1254;
mul.f32 f1252, f404, f634;
mul.f32 f641, f599, f634;
fma.rn.f32 f642, f600, f632, f641;
mul.f32 f643, f463, f642;
mul.f32 f645, f640, f463;
mul.f32 f647, f600, f642;
mul.f32 f1251, f599, f640;
sub.f32 f648, f1251, f647;
mul.f32 f1250, f446, f642;
mul.f32 f649, f599, f642;
fma.rn.f32 f650, f600, f640, f649;
mul.f32 f651, f505, f650;
mul.f32 f653, f648, f505;
mul.f32 f655, f600, f650;
mul.f32 f1249, f599, f648;
sub.f32 f656, f1249, f655;
mul.f32 f1248, f488, f650;
mul.f32 f657, f599, f650;
fma.rn.f32 f658, f600, f648, f657;
mul.f32 f659, f547, f658;
mul.f32 f661, f656, f547;
mul.f32 f1246, f599, f656;
mul.f32 f1247, f600, f658;
sub.f32 f664, f1246, f1247;
mul.f32 f1245, f530, f658;
mul.f32 f665, f599, f658;
fma.rn.f32 f666, f600, f656, f665;
mul.f32 f667, f589, f666;
mul.f32 f669, f664, f589;
mul.f32 f671, f600, f666;
mul.f32 f1244, f599, f664;
sub.f32 f672, f1244, f671;
mul.f32 f1243, f572, f666;
mul.f32 f673, f599, f666;
fma.rn.f32 f674, f600, f664, f673;
mul.f32 f675, f429, f674;
mul.f32 f677, f672, f429;
mul.f32 f679, f600, f674;
mul.f32 f1242, f599, f672;
sub.f32 f680, f1242, f679;
mul.f32 f1241, f412, f674;
mul.f32 f681, f599, f674;
fma.rn.f32 f682, f600, f672, f681;
mul.f32 f683, f471, f682;
mul.f32 f685, f680, f471;
mul.f32 f1239, f599, f680;
mul.f32 f1240, f600, f682;
sub.f32 f688, f1239, f1240;
mul.f32 f1238, f454, f682;
mul.f32 f689, f599, f682;
fma.rn.f32 f690, f600, f680, f689;
mul.f32 f691, f513, f690;
mul.f32 f693, f688, f513;
mul.f32 f695, f600, f690;
mul.f32 f1237, f599, f688;
sub.f32 f696, f1237, f695;
mul.f32 f1236, f496, f690;
mul.f32 f697, f599, f690;
fma.rn.f32 f698, f600, f688, f697;
mul.f32 f699, f555, f698;
mul.f32 f701, f696, f555;
mul.f32 f1234, f599, f696;
mul.f32 f1235, f600, f698;
sub.f32 f704, f1234, f1235;
mul.f32 f1233, f538, f698;
mul.f32 f705, f599, f698;
fma.rn.f32 f706, f600, f696, f705;
mul.f32 f707, f597, f706;
mul.f32 f709, f704, f597;
mul.f32 f711, f600, f706;
mul.f32 f1232, f599, f704;
sub.f32 f712, f1232, f711;
mul.f32 f1231, f580, f706;
mul.f32 f713, f599, f706;
fma.rn.f32 f714, f600, f704, f713;
mul.f32 f715, f430, f714;
mul.f32 f717, f712, f430;
mul.f32 f719, f600, f714;
mul.f32 f1230, f599, f712;
sub.f32 f720, f1230, f719;
mul.f32 f1229, f413, f714;
mul.f32 f721, f599, f714;
fma.rn.f32 f722, f600, f712, f721;
mul.f32 f723, f472, f722;
mul.f32 f725, f720, f472;
mul.f32 f1227, f599, f720;
mul.f32 f1228, f600, f722;
sub.f32 f728, f1227, f1228;
mul.f32 f1226, f455, f722;
mul.f32 f729, f599, f722;
fma.rn.f32 f730, f600, f720, f729;
mul.f32 f731, f514, f730;
mul.f32 f733, f728, f514;
mul.f32 f735, f600, f730;
mul.f32 f1225, f599, f728;
sub.f32 f736, f1225, f735;
mul.f32 f1224, f497, f730;
mul.f32 f737, f599, f730;
fma.rn.f32 f738, f600, f728, f737;
mul.f32 f739, f556, f738;
mul.f32 f741, f736, f556;
mul.f32 f743, f600, f738;
mul.f32 f1223, f599, f736;
sub.f32 f744, f1223, f743;
mul.f32 f1222, f539, f738;
mul.f32 f745, f599, f738;
fma.rn.f32 f746, f600, f736, f745;
mul.f32 f747, f598, f746;
mul.f32 f749, f744, f598;
mul.f32 f1220, f599, f744;
mul.f32 f1221, f600, f746;
sub.f32 f752, f1220, f1221;
mul.f32 f1219, f581, f746;
mul.f32 f753, f599, f746;
fma.rn.f32 f754, f600, f744, f753;
mul.f32 f755, f422, f754;
mul.f32 f757, f752, f422;
mul.f32 f759, f600, f754;
mul.f32 f1218, f599, f752;
sub.f32 f760, f1218, f759;
mul.f32 f1217, f405, f754;
mul.f32 f761, f599, f754;
fma.rn.f32 f762, f600, f752, f761;
mul.f32 f763, f464, f762;
mul.f32 f765, f760, f464;
mul.f32 f1215, f599, f760;
mul.f32 f1216, f600, f762;
sub.f32 f768, f1215, f1216;
mul.f32 f1214, f447, f762;
mul.f32 f769, f599, f762;
fma.rn.f32 f770, f600, f760, f769;
mul.f32 f771, f506, f770;
mul.f32 f773, f768, f506;
mul.f32 f775, f600, f770;
mul.f32 f1213, f599, f768;
sub.f32 f776, f1213, f775;
mul.f32 f1212, f489, f770;
mul.f32 f777, f599, f770;
fma.rn.f32 f778, f600, f768, f777;
mul.f32 f779, f548, f778;
mul.f32 f781, f776, f548;
mul.f32 f783, f600, f778;
mul.f32 f1211, f599, f776;
sub.f32 f784, f1211, f783;
mul.f32 f1210, f531, f778;
mul.f32 f785, f599, f778;
mul.f32 f1209, f434, f600;
fma.rn.f32 f786, f600, f776, f785;
mul.f32 f787, f590, f786;
mul.f32 f788, f573, f786;
mul.f32 f789, f784, f590;
barrier.sync 0;
mad.lo.s32 r9, r7, 200, r8;
add.f32 f790, f1295, f1290;
add.f32 f791, f393, f1293;
st.shared.v2.f32 [r9], {f791, f790};
fma.rn.f32 f792, f599, f434, f603;
sub.f32 f793, f605, f1209;
st.shared.v2.f32 [r9+8], {f792, f793};
fma.rn.f32 f794, f608, f476, f611;
sub.f32 f795, f613, f1260;
st.shared.v2.f32 [r9+16], {f794, f795};
fma.rn.f32 f796, f616, f518, f619;
sub.f32 f797, f621, f1257;
st.shared.v2.f32 [r9+24], {f796, f797};
fma.rn.f32 f798, f624, f560, f627;
sub.f32 f799, f629, f1255;
st.shared.v2.f32 [r9+32], {f798, f799};
sub.f32 f800, f637, f1252;
fma.rn.f32 f801, f632, f404, f635;
st.shared.v2.f32 [r9+40], {f801, f800};
fma.rn.f32 f802, f640, f446, f643;
sub.f32 f803, f645, f1250;
st.shared.v2.f32 [r9+48], {f802, f803};
sub.f32 f804, f653, f1248;
fma.rn.f32 f805, f648, f488, f651;
st.shared.v2.f32 [r9+56], {f805, f804};
fma.rn.f32 f806, f656, f530, f659;
sub.f32 f807, f661, f1245;
st.shared.v2.f32 [r9+64], {f806, f807};
fma.rn.f32 f808, f664, f572, f667;
sub.f32 f809, f669, f1243;
st.shared.v2.f32 [r9+72], {f808, f809};
fma.rn.f32 f810, f672, f412, f675;
sub.f32 f811, f677, f1241;
st.shared.v2.f32 [r9+80], {f810, f811};
fma.rn.f32 f812, f680, f454, f683;
sub.f32 f813, f685, f1238;
st.shared.v2.f32 [r9+88], {f812, f813};
fma.rn.f32 f814, f688, f496, f691;
sub.f32 f815, f693, f1236;
st.shared.v2.f32 [r9+96], {f814, f815};
fma.rn.f32 f816, f696, f538, f699;
sub.f32 f817, f701, f1233;
st.shared.v2.f32 [r9+104], {f816, f817};
fma.rn.f32 f818, f704, f580, f707;
sub.f32 f819, f709, f1231;
st.shared.v2.f32 [r9+112], {f818, f819};
fma.rn.f32 f820, f712, f413, f715;
sub.f32 f821, f717, f1229;
st.shared.v2.f32 [r9+120], {f820, f821};
fma.rn.f32 f822, f720, f455, f723;
sub.f32 f823, f725, f1226;
st.shared.v2.f32 [r9+128], {f822, f823};
fma.rn.f32 f824, f728, f497, f731;
sub.f32 f825, f733, f1224;
st.shared.v2.f32 [r9+136], {f824, f825};
fma.rn.f32 f826, f736, f539, f739;
sub.f32 f827, f741, f1222;
st.shared.v2.f32 [r9+144], {f826, f827};
fma.rn.f32 f828, f744, f581, f747;
sub.f32 f829, f749, f1219;
st.shared.v2.f32 [r9+152], {f828, f829};
fma.rn.f32 f830, f752, f405, f755;
sub.f32 f831, f757, f1217;
st.shared.v2.f32 [r9+160], {f830, f831};
fma.rn.f32 f832, f760, f447, f763;
sub.f32 f833, f765, f1214;
st.shared.v2.f32 [r9+168], {f832, f833};
fma.rn.f32 f834, f768, f489, f771;
sub.f32 f835, f773, f1212;
st.shared.v2.f32 [r9+176], {f834, f835};
fma.rn.f32 f836, f776, f531, f779;
sub.f32 f837, f781, f1210;
st.shared.v2.f32 [r9+184], {f836, f837};
fma.rn.f32 f838, f784, f573, f787;
sub.f32 f839, f789, f788;
st.shared.v2.f32 [r9+192], {f838, f839};
barrier.sync 0;
mad.lo.s32 r10, r7, -192, r9;
ld.shared.v2.f32 {f840, f841}, [r10];
ld.shared.v2.f32 {f844, f845}, [r10+40];
ld.shared.v2.f32 {f848, f849}, [r10+80];
ld.shared.v2.f32 {f852, f853}, [r10+120];
ld.shared.v2.f32 {f856, f857}, [r10+160];
ld.shared.v2.f32 {f860, f861}, [r10+200];
ld.shared.v2.f32 {f864, f865}, [r10+240];
ld.shared.v2.f32 {f868, f869}, [r10+280];
ld.shared.v2.f32 {f872, f873}, [r10+320];
ld.shared.v2.f32 {f876, f877}, [r10+360];
ld.shared.v2.f32 {f880, f881}, [r10+400];
ld.shared.v2.f32 {f884, f885}, [r10+440];
ld.shared.v2.f32 {f888, f889}, [r10+480];
ld.shared.v2.f32 {f892, f893}, [r10+520];
ld.shared.v2.f32 {f896, f897}, [r10+560];
ld.shared.v2.f32 {f900, f901}, [r10+600];
ld.shared.v2.f32 {f904, f905}, [r10+640];
ld.shared.v2.f32 {f908, f909}, [r10+680];
ld.shared.v2.f32 {f912, f913}, [r10+720];
ld.shared.v2.f32 {f916, f917}, [r10+760];
ld.shared.v2.f32 {f920, f921}, [r10+800];
ld.shared.v2.f32 {f924, f925}, [r10+840];
ld.shared.v2.f32 {f928, f929}, [r10+880];
ld.shared.v2.f32 {f932, f933}, [r10+920];
ld.shared.v2.f32 {f936, f937}, [r10+960];
add.f32 f940, f860, f920;
add.f32 f942, f880, f900;
mul.f32 f947, f942, 0f3F4F1BBD;
fma.rn.f32 f1208, f940, 0f3E9E377A, f840;
sub.f32 f948, f1208, f947;
add.f32 f1207, f861, f921;
sub.f32 f949, f861, f921;
add.f32 f1206, f881, f901;
sub.f32 f951, f881, f901;
mul.f32 f1205, f949, 0f3F737871;
fma.rn.f32 f952, f951, 0f3F167918, f1205;
add.f32 f1204, f840, f940;
mul.f32 f953, f940, 0f3F4F1BBD;
sub.f32 f954, f840, f953;
fma.rn.f32 f955, f942, 0f3E9E377A, f954;
mul.f32 f956, f949, 0f3F167918;
mul.f32 f957, f951, 0f3F737871;
sub.f32 f958, f956, f957;
fma.rn.f32 f1202, f1207, 0f3E9E377A, f841;
mul.f32 f1203, f1206, 0f3F4F1BBD;
sub.f32 f961, f1202, f1203;
sub.f32 f962, f860, f920;
sub.f32 f964, f880, f900;
mul.f32 f1201, f962, 0f3F737871;
fma.rn.f32 f965, f964, 0f3F167918, f1201;
add.f32 f1200, f841, f1207;
mul.f32 f966, f1207, 0f3F4F1BBD;
sub.f32 f967, f841, f966;
fma.rn.f32 f968, f1206, 0f3E9E377A, f967;
mul.f32 f969, f962, 0f3F167918;
mul.f32 f970, f964, 0f3F737871;
sub.f32 f971, f969, f970;
add.f32 f972, f864, f924;
add.f32 f974, f884, f904;
fma.rn.f32 f1198, f972, 0f3E9E377A, f844;
mul.f32 f1199, f974, 0f3F4F1BBD;
sub.f32 f980, f1198, f1199;
add.f32 f1197, f865, f925;
sub.f32 f981, f865, f925;
add.f32 f1196, f885, f905;
sub.f32 f983, f885, f905;
mul.f32 f1195, f981, 0f3F737871;
fma.rn.f32 f984, f983, 0f3F167918, f1195;
add.f32 f1194, f844, f972;
mul.f32 f985, f972, 0f3F4F1BBD;
sub.f32 f986, f844, f985;
fma.rn.f32 f987, f974, 0f3E9E377A, f986;
mul.f32 f988, f981, 0f3F167918;
mul.f32 f989, f983, 0f3F737871;
sub.f32 f990, f988, f989;
mul.f32 f992, f1196, 0f3F4F1BBD;
fma.rn.f32 f1193, f1197, 0f3E9E377A, f845;
sub.f32 f993, f1193, f992;
sub.f32 f994, f864, f924;
sub.f32 f996, f884, f904;
mul.f32 f1192, f994, 0f3F737871;
fma.rn.f32 f997, f996, 0f3F167918, f1192;
add.f32 f1191, f845, f1197;
mul.f32 f998, f1197, 0f3F4F1BBD;
sub.f32 f999, f845, f998;
fma.rn.f32 f1000, f1196, 0f3E9E377A, f999;
mul.f32 f1001, f994, 0f3F167918;
mul.f32 f1002, f996, 0f3F737871;
sub.f32 f1003, f1001, f1002;
add.f32 f1004, f868, f928;
add.f32 f1006, f888, f908;
mul.f32 f1011, f1006, 0f3F4F1BBD;
fma.rn.f32 f1190, f1004, 0f3E9E377A, f848;
sub.f32 f1012, f1190, f1011;
add.f32 f1189, f869, f929;
sub.f32 f1013, f869, f929;
add.f32 f1188, f889, f909;
sub.f32 f1015, f889, f909;
mul.f32 f1187, f1013, 0f3F737871;
fma.rn.f32 f1016, f1015, 0f3F167918, f1187;
add.f32 f1186, f848, f1004;
mul.f32 f1017, f1004, 0f3F4F1BBD;
sub.f32 f1018, f848, f1017;
fma.rn.f32 f1019, f1006, 0f3E9E377A, f1018;
mul.f32 f1020, f1013, 0f3F167918;
mul.f32 f1021, f1015, 0f3F737871;
sub.f32 f1022, f1020, f1021;
fma.rn.f32 f1184, f1189, 0f3E9E377A, f849;
mul.f32 f1185, f1188, 0f3F4F1BBD;
sub.f32 f1025, f1184, f1185;
sub.f32 f1026, f868, f928;
sub.f32 f1028, f888, f908;
mul.f32 f1183, f1026, 0f3F737871;
fma.rn.f32 f1029, f1028, 0f3F167918, f1183;
add.f32 f1182, f849, f1189;
mul.f32 f1030, f1189, 0f3F4F1BBD;
sub.f32 f1031, f849, f1030;
fma.rn.f32 f1032, f1188, 0f3E9E377A, f1031;
mul.f32 f1033, f1026, 0f3F167918;
mul.f32 f1034, f1028, 0f3F737871;
sub.f32 f1035, f1033, f1034;
add.f32 f1036, f872, f932;
add.f32 f1038, f892, f912;
fma.rn.f32 f1180, f1036, 0f3E9E377A, f852;
mul.f32 f1181, f1038, 0f3F4F1BBD;
sub.f32 f1044, f1180, f1181;
add.f32 f1179, f873, f933;
sub.f32 f1045, f873, f933;
add.f32 f1178, f893, f913;
sub.f32 f1047, f893, f913;
mul.f32 f1177, f1045, 0f3F737871;
fma.rn.f32 f1048, f1047, 0f3F167918, f1177;
add.f32 f1176, f852, f1036;
mul.f32 f1049, f1036, 0f3F4F1BBD;
sub.f32 f1050, f852, f1049;
fma.rn.f32 f1051, f1038, 0f3E9E377A, f1050;
mul.f32 f1052, f1045, 0f3F167918;
mul.f32 f1053, f1047, 0f3F737871;
sub.f32 f1054, f1052, f1053;
mul.f32 f1056, f1178, 0f3F4F1BBD;
fma.rn.f32 f1175, f1179, 0f3E9E377A, f853;
sub.f32 f1057, f1175, f1056;
sub.f32 f1058, f872, f932;
sub.f32 f1060, f892, f912;
mul.f32 f1174, f1058, 0f3F737871;
fma.rn.f32 f1061, f1060, 0f3F167918, f1174;
add.f32 f1173, f853, f1179;
mul.f32 f1062, f1179, 0f3F4F1BBD;
sub.f32 f1063, f853, f1062;
fma.rn.f32 f1064, f1178, 0f3E9E377A, f1063;
mul.f32 f1065, f1058, 0f3F167918;
mul.f32 f1066, f1060, 0f3F737871;
sub.f32 f1067, f1065, f1066;
add.f32 f1068, f876, f936;
add.f32 f1070, f896, f916;
mul.f32 f1075, f1070, 0f3F4F1BBD;
fma.rn.f32 f1172, f1068, 0f3E9E377A, f856;
sub.f32 f1076, f1172, f1075;
add.f32 f1171, f877, f937;
sub.f32 f1077, f877, f937;
add.f32 f1170, f897, f917;
sub.f32 f1079, f897, f917;
mul.f32 f1169, f1077, 0f3F737871;
fma.rn.f32 f1080, f1079, 0f3F167918, f1169;
add.f32 f1168, f856, f1068;
mul.f32 f1081, f1068, 0f3F4F1BBD;
sub.f32 f1082, f856, f1081;
fma.rn.f32 f1083, f1070, 0f3E9E377A, f1082;
mul.f32 f1084, f1077, 0f3F167918;
mul.f32 f1085, f1079, 0f3F737871;
sub.f32 f1086, f1084, f1085;
fma.rn.f32 f1166, f1171, 0f3E9E377A, f857;
mul.f32 f1167, f1170, 0f3F4F1BBD;
sub.f32 f1089, f1166, f1167;
sub.f32 f1090, f876, f936;
sub.f32 f1092, f896, f916;
mul.f32 f1165, f1090, 0f3F737871;
fma.rn.f32 f1093, f1092, 0f3F167918, f1165;
add.f32 f1164, f857, f1171;
mul.f32 f1094, f1171, 0f3F4F1BBD;
sub.f32 f1095, f857, f1094;
fma.rn.f32 f1096, f1170, 0f3E9E377A, f1095;
mul.f32 f1097, f1090, 0f3F167918;
mul.f32 f1098, f1092, 0f3F737871;
sub.f32 f1099, f1097, f1098;
add.f32 %1, f1206, f1200;
add.f32 %0, f942, f1204;
add.f32 %3, f1196, f1191;
add.f32 %2, f974, f1194;
add.f32 %5, f1188, f1182;
add.f32 %4, f1006, f1186;
add.f32 %7, f1178, f1173;
add.f32 %6, f1038, f1176;
add.f32 %9, f1170, f1164;
add.f32 %8, f1070, f1168;
add.f32 %11, f965, f961;
sub.f32 %10, f948, f952;
sub.f32 %12, f980, f984;
add.f32 %13, f997, f993;
sub.f32 %14, f1012, f1016;
add.f32 %15, f1029, f1025;
sub.f32 %16, f1044, f1048;
add.f32 %17, f1061, f1057;
add.f32 %19, f1093, f1089;
sub.f32 %18, f1076, f1080;
add.f32 %21, f971, f968;
sub.f32 %20, f955, f958;
add.f32 %23, f1003, f1000;
sub.f32 %22, f987, f990;
sub.f32 %24, f1019, f1022;
add.f32 %25, f1035, f1032;
sub.f32 %26, f1051, f1054;
add.f32 %27, f1067, f1064;
sub.f32 %28, f1083, f1086;
add.f32 %29, f1099, f1096;
sub.f32 %31, f968, f971;
add.f32 %30, f958, f955;
sub.f32 %33, f1000, f1003;
add.f32 %32, f990, f987;
sub.f32 %35, f1032, f1035;
add.f32 %34, f1022, f1019;
sub.f32 %37, f1064, f1067;
add.f32 %36, f1054, f1051;
sub.f32 %39, f1096, f1099;
add.f32 %38, f1086, f1083;
sub.f32 %41, f961, f965;
add.f32 %40, f952, f948;
sub.f32 %43, f993, f997;
add.f32 %42, f984, f980;
sub.f32 %45, f1025, f1029;
add.f32 %44, f1016, f1012;
sub.f32 %47, f1057, f1061;
add.f32 %46, f1048, f1044;
sub.f32 %49, f1089, f1093;
add.f32 %48, f1080, f1076;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_125), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[5].y), "f"(rmem[10].y), "f"(rmem[20].y), "f"(rmem[16].y), "f"(rmem[1].y), "f"(rmem[11].y), "f"(rmem[2].y), "f"(rmem[22].y), "f"(rmem[7].y), "f"(rmem[17].y), "f"(rmem[8].y), "f"(rmem[13].y), "f"(rmem[23].y), "f"(rmem[4].y), "f"(rmem[14].y), "f"(rmem[19].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<360, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1100>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %50;
mad.lo.s32 r3, r1, 500, r2;
add.f32 f101, %65, %105;
add.f32 f102, %52, f101;
add.f32 f103, %78, %92;
add.f32 f104, f103, f102;
add.f32 f105, %67, %107;
add.f32 f106, %53, f105;
add.f32 f107, %80, %93;
add.f32 f108, f107, f106;
fma.rn.f32 f109, f101, 0f3E9E377A, %52;
mul.f32 f110, f103, 0f3F4F1BBD;
sub.f32 f111, f109, f110;
sub.f32 f112, %67, %107;
mul.f32 f113, f112, 0f3F737871;
sub.f32 f114, %80, %93;
fma.rn.f32 f115, f114, 0f3F167918, f113;
sub.f32 f116, f111, f115;
add.f32 f117, f115, f111;
mul.f32 f118, f101, 0f3F4F1BBD;
sub.f32 f119, %52, f118;
fma.rn.f32 f120, f103, 0f3E9E377A, f119;
mul.f32 f121, f112, 0f3F167918;
mul.f32 f122, f114, 0f3F737871;
sub.f32 f123, f121, f122;
sub.f32 f124, f120, f123;
add.f32 f125, f123, f120;
fma.rn.f32 f126, f105, 0f3E9E377A, %53;
mul.f32 f127, f107, 0f3F4F1BBD;
sub.f32 f128, f126, f127;
sub.f32 f129, %65, %105;
mul.f32 f130, f129, 0f3F737871;
sub.f32 f131, %78, %92;
fma.rn.f32 f132, f131, 0f3F167918, f130;
add.f32 f133, f132, f128;
sub.f32 f134, f128, f132;
mul.f32 f135, f105, 0f3F4F1BBD;
sub.f32 f136, %53, f135;
fma.rn.f32 f137, f107, 0f3E9E377A, f136;
mul.f32 f138, f129, 0f3F167918;
mul.f32 f139, f131, 0f3F737871;
sub.f32 f140, f138, f139;
add.f32 f141, f140, f137;
sub.f32 f142, f137, f140;
add.f32 f143, %68, %108;
add.f32 f144, %54, f143;
add.f32 f145, %81, %94;
add.f32 f146, f145, f144;
add.f32 f147, %69, %109;
add.f32 f148, %56, f147;
add.f32 f149, %83, %96;
add.f32 f150, f149, f148;
fma.rn.f32 f151, f143, 0f3E9E377A, %54;
mul.f32 f152, f145, 0f3F4F1BBD;
sub.f32 f153, f151, f152;
sub.f32 f154, %69, %109;
mul.f32 f155, f154, 0f3F737871;
sub.f32 f156, %83, %96;
fma.rn.f32 f157, f156, 0f3F167918, f155;
sub.f32 f158, f153, f157;
add.f32 f159, f157, f153;
mul.f32 f160, f143, 0f3F4F1BBD;
sub.f32 f161, %54, f160;
fma.rn.f32 f162, f145, 0f3E9E377A, f161;
mul.f32 f163, f154, 0f3F167918;
mul.f32 f164, f156, 0f3F737871;
sub.f32 f165, f163, f164;
sub.f32 f166, f162, f165;
add.f32 f167, f165, f162;
fma.rn.f32 f168, f147, 0f3E9E377A, %56;
mul.f32 f169, f149, 0f3F4F1BBD;
sub.f32 f170, f168, f169;
sub.f32 f171, %68, %108;
mul.f32 f172, f171, 0f3F737871;
sub.f32 f173, %81, %94;
fma.rn.f32 f174, f173, 0f3F167918, f172;
add.f32 f175, f174, f170;
sub.f32 f176, f170, f174;
mul.f32 f177, f147, 0f3F4F1BBD;
sub.f32 f178, %56, f177;
fma.rn.f32 f179, f149, 0f3E9E377A, f178;
mul.f32 f180, f171, 0f3F167918;
mul.f32 f181, f173, 0f3F737871;
sub.f32 f182, f180, f181;
add.f32 f183, f182, f179;
sub.f32 f184, f179, f182;
add.f32 f185, %70, %110;
add.f32 f186, %57, f185;
add.f32 f187, %84, %97;
add.f32 f188, f187, f186;
add.f32 f189, %72, %112;
add.f32 f190, %59, f189;
add.f32 f191, %85, %99;
add.f32 f192, f191, f190;
fma.rn.f32 f193, f185, 0f3E9E377A, %57;
mul.f32 f194, f187, 0f3F4F1BBD;
sub.f32 f195, f193, f194;
sub.f32 f196, %72, %112;
mul.f32 f197, f196, 0f3F737871;
sub.f32 f198, %85, %99;
fma.rn.f32 f199, f198, 0f3F167918, f197;
sub.f32 f200, f195, f199;
add.f32 f201, f199, f195;
mul.f32 f202, f185, 0f3F4F1BBD;
sub.f32 f203, %57, f202;
fma.rn.f32 f204, f187, 0f3E9E377A, f203;
mul.f32 f205, f196, 0f3F167918;
mul.f32 f206, f198, 0f3F737871;
sub.f32 f207, f205, f206;
sub.f32 f208, f204, f207;
add.f32 f209, f207, f204;
fma.rn.f32 f210, f189, 0f3E9E377A, %59;
mul.f32 f211, f191, 0f3F4F1BBD;
sub.f32 f212, f210, f211;
sub.f32 f213, %70, %110;
mul.f32 f214, f213, 0f3F737871;
sub.f32 f215, %84, %97;
fma.rn.f32 f216, f215, 0f3F167918, f214;
add.f32 f217, f216, f212;
sub.f32 f218, f212, f216;
mul.f32 f219, f189, 0f3F4F1BBD;
sub.f32 f220, %59, f219;
fma.rn.f32 f221, f191, 0f3E9E377A, f220;
mul.f32 f222, f213, 0f3F167918;
mul.f32 f223, f215, 0f3F737871;
sub.f32 f224, f222, f223;
add.f32 f225, f224, f221;
sub.f32 f226, f221, f224;
add.f32 f227, %73, %113;
add.f32 f228, %60, f227;
add.f32 f229, %86, %100;
add.f32 f230, f229, f228;
add.f32 f231, %75, %115;
add.f32 f232, %61, f231;
add.f32 f233, %88, %101;
add.f32 f234, f233, f232;
fma.rn.f32 f235, f227, 0f3E9E377A, %60;
mul.f32 f236, f229, 0f3F4F1BBD;
sub.f32 f237, f235, f236;
sub.f32 f238, %75, %115;
mul.f32 f239, f238, 0f3F737871;
sub.f32 f240, %88, %101;
fma.rn.f32 f241, f240, 0f3F167918, f239;
sub.f32 f242, f237, f241;
add.f32 f243, f241, f237;
mul.f32 f244, f227, 0f3F4F1BBD;
sub.f32 f245, %60, f244;
fma.rn.f32 f246, f229, 0f3E9E377A, f245;
mul.f32 f247, f238, 0f3F167918;
mul.f32 f248, f240, 0f3F737871;
sub.f32 f249, f247, f248;
sub.f32 f250, f246, f249;
add.f32 f251, f249, f246;
fma.rn.f32 f252, f231, 0f3E9E377A, %61;
mul.f32 f253, f233, 0f3F4F1BBD;
sub.f32 f254, f252, f253;
sub.f32 f255, %73, %113;
mul.f32 f256, f255, 0f3F737871;
sub.f32 f257, %86, %100;
fma.rn.f32 f258, f257, 0f3F167918, f256;
add.f32 f259, f258, f254;
sub.f32 f260, f254, f258;
mul.f32 f261, f231, 0f3F4F1BBD;
sub.f32 f262, %61, f261;
fma.rn.f32 f263, f233, 0f3E9E377A, f262;
mul.f32 f264, f255, 0f3F167918;
mul.f32 f265, f257, 0f3F737871;
sub.f32 f266, f264, f265;
add.f32 f267, f266, f263;
sub.f32 f268, f263, f266;
add.f32 f269, %76, %116;
add.f32 f270, %62, f269;
add.f32 f271, %89, %102;
add.f32 f272, f271, f270;
add.f32 f273, %77, %117;
add.f32 f274, %64, f273;
add.f32 f275, %91, %104;
add.f32 f276, f275, f274;
fma.rn.f32 f277, f269, 0f3E9E377A, %62;
mul.f32 f278, f271, 0f3F4F1BBD;
sub.f32 f279, f277, f278;
sub.f32 f280, %77, %117;
mul.f32 f281, f280, 0f3F737871;
sub.f32 f282, %91, %104;
fma.rn.f32 f283, f282, 0f3F167918, f281;
sub.f32 f284, f279, f283;
add.f32 f285, f283, f279;
mul.f32 f286, f269, 0f3F4F1BBD;
sub.f32 f287, %62, f286;
fma.rn.f32 f288, f271, 0f3E9E377A, f287;
mul.f32 f289, f280, 0f3F167918;
mul.f32 f290, f282, 0f3F737871;
sub.f32 f291, f289, f290;
sub.f32 f292, f288, f291;
add.f32 f293, f291, f288;
fma.rn.f32 f294, f273, 0f3E9E377A, %64;
mul.f32 f295, f275, 0f3F4F1BBD;
sub.f32 f296, f294, f295;
sub.f32 f297, %76, %116;
mul.f32 f298, f297, 0f3F737871;
sub.f32 f299, %89, %102;
fma.rn.f32 f300, f299, 0f3F167918, f298;
add.f32 f301, f300, f296;
sub.f32 f302, f296, f300;
mul.f32 f303, f273, 0f3F4F1BBD;
sub.f32 f304, %64, f303;
fma.rn.f32 f305, f275, 0f3E9E377A, f304;
mul.f32 f306, f297, 0f3F167918;
mul.f32 f307, f299, 0f3F737871;
sub.f32 f308, f306, f307;
add.f32 f309, f308, f305;
sub.f32 f310, f305, f308;
mov.u32 r4, %tid.x;
mul.f32 f311, f158, 0f3F77F511;
mul.f32 f312, f175, 0f3E7EA890;
sub.f32 f313, f311, f312;
mul.f32 f314, f175, 0f3F77F511;
fma.rn.f32 f315, f158, 0f3E7EA890, f314;
mul.f32 f316, f200, 0f3F6055A2;
mul.f32 f317, f217, 0f3EF6A86B;
sub.f32 f318, f316, f317;
mul.f32 f319, f217, 0f3F6055A2;
fma.rn.f32 f320, f200, 0f3EF6A86B, f319;
mul.f32 f321, f242, 0f3F3A9DB0;
mul.f32 f322, f259, 0f3F2F3E7B;
sub.f32 f323, f321, f322;
mul.f32 f324, f259, 0f3F3A9DB0;
fma.rn.f32 f325, f242, 0f3F2F3E7B, f324;
mul.f32 f326, f284, 0f3F092BF2;
mul.f32 f327, f301, 0f3F5825E0;
sub.f32 f328, f326, f327;
mul.f32 f329, f301, 0f3F092BF2;
fma.rn.f32 f330, f284, 0f3F5825E0, f329;
mul.f32 f331, f166, 0f3F6055A2;
mul.f32 f332, f183, 0f3EF6A86B;
sub.f32 f333, f331, f332;
mul.f32 f334, f183, 0f3F6055A2;
fma.rn.f32 f335, f166, 0f3EF6A86B, f334;
mul.f32 f336, f208, 0f3F092BF2;
mul.f32 f337, f225, 0f3F5825E0;
sub.f32 f338, f336, f337;
mul.f32 f339, f225, 0f3F092BF2;
fma.rn.f32 f340, f208, 0f3F5825E0, f339;
mul.f32 f341, f250, 0f3D809851;
mul.f32 f342, f267, 0f3F7F7EAE;
sub.f32 f343, f341, f342;
mul.f32 f344, f267, 0f3D809851;
fma.rn.f32 f345, f250, 0f3F7F7EAE, f344;
mul.f32 f346, f292, 0fBED9FFBE;
mul.f32 f347, f309, 0f3F67A2BF;
sub.f32 f348, f346, f347;
mul.f32 f349, f309, 0fBED9FFBE;
fma.rn.f32 f350, f292, 0f3F67A2BF, f349;
mul.f32 f351, f167, 0f3F3A9DB0;
mul.f32 f352, f184, 0f3F2F3E7B;
sub.f32 f353, f351, f352;
mul.f32 f354, f184, 0f3F3A9DB0;
fma.rn.f32 f355, f167, 0f3F2F3E7B, f354;
mul.f32 f356, f209, 0f3D809851;
mul.f32 f357, f226, 0f3F7F7EAE;
sub.f32 f358, f356, f357;
mul.f32 f359, f226, 0f3D809851;
fma.rn.f32 f360, f209, 0f3F7F7EAE, f359;
mul.f32 f361, f251, 0fBF232E38;
mul.f32 f362, f268, 0f3F45405B;
sub.f32 f363, f361, f362;
mul.f32 f364, f268, 0fBF232E38;
fma.rn.f32 f365, f251, 0f3F45405B, f364;
mul.f32 f366, f293, 0fBF7DFB3B;
mul.f32 f367, f310, 0f3E00575B;
sub.f32 f368, f366, f367;
mul.f32 f369, f310, 0fBF7DFB3B;
fma.rn.f32 f370, f293, 0f3E00575B, f369;
mul.f32 f371, f159, 0f3F092BF2;
mul.f32 f372, f176, 0f3F5825E0;
sub.f32 f373, f371, f372;
mul.f32 f374, f176, 0f3F092BF2;
fma.rn.f32 f375, f159, 0f3F5825E0, f374;
mul.f32 f376, f201, 0fBED9FFBE;
mul.f32 f377, f218, 0f3F67A2BF;
sub.f32 f378, f376, f377;
mul.f32 f379, f218, 0fBED9FFBE;
fma.rn.f32 f380, f201, 0f3F67A2BF, f379;
mul.f32 f381, f243, 0fBF7DFB3B;
mul.f32 f382, f260, 0f3E00575B;
sub.f32 f383, f381, f382;
mul.f32 f384, f260, 0fBF7DFB3B;
fma.rn.f32 f385, f243, 0f3E00575B, f384;
mul.f32 f386, f285, 0fBF232E38;
mul.f32 f387, f302, 0fBF45405B;
sub.f32 f388, f386, f387;
mul.f32 f389, f302, 0fBF232E38;
fma.rn.f32 f390, f285, 0fBF45405B, f389;
add.f32 f391, f146, f272;
add.f32 f392, f104, f391;
add.f32 f393, f188, f230;
add.f32 f394, f393, f392;
add.f32 f395, f150, f276;
add.f32 f396, f108, f395;
add.f32 f397, f192, f234;
add.f32 f398, f397, f396;
fma.rn.f32 f399, f391, 0f3E9E377A, f104;
mul.f32 f400, f393, 0f3F4F1BBD;
sub.f32 f401, f399, f400;
sub.f32 f402, f150, f276;
mul.f32 f403, f402, 0f3F737871;
sub.f32 f404, f192, f234;
fma.rn.f32 f405, f404, 0f3F167918, f403;
sub.f32 f406, f401, f405;
add.f32 f407, f405, f401;
mul.f32 f408, f391, 0f3F4F1BBD;
sub.f32 f409, f104, f408;
fma.rn.f32 f410, f393, 0f3E9E377A, f409;
mul.f32 f411, f402, 0f3F167918;
mul.f32 f412, f404, 0f3F737871;
sub.f32 f413, f411, f412;
sub.f32 f414, f410, f413;
add.f32 f415, f413, f410;
fma.rn.f32 f416, f395, 0f3E9E377A, f108;
mul.f32 f417, f397, 0f3F4F1BBD;
sub.f32 f418, f416, f417;
sub.f32 f419, f146, f272;
mul.f32 f420, f419, 0f3F737871;
sub.f32 f421, f188, f230;
fma.rn.f32 f422, f421, 0f3F167918, f420;
add.f32 f423, f422, f418;
sub.f32 f424, f418, f422;
mul.f32 f425, f395, 0f3F4F1BBD;
sub.f32 f426, f108, f425;
fma.rn.f32 f427, f397, 0f3E9E377A, f426;
mul.f32 f428, f419, 0f3F167918;
mul.f32 f429, f421, 0f3F737871;
sub.f32 f430, f428, f429;
add.f32 f431, f430, f427;
sub.f32 f432, f427, f430;
add.f32 f433, f313, f328;
add.f32 f434, f116, f433;
add.f32 f435, f318, f323;
add.f32 f436, f435, f434;
add.f32 f437, f315, f330;
add.f32 f438, f133, f437;
add.f32 f439, f320, f325;
add.f32 f440, f439, f438;
fma.rn.f32 f441, f433, 0f3E9E377A, f116;
mul.f32 f442, f435, 0f3F4F1BBD;
sub.f32 f443, f441, f442;
sub.f32 f444, f315, f330;
mul.f32 f445, f444, 0f3F737871;
sub.f32 f446, f320, f325;
fma.rn.f32 f447, f446, 0f3F167918, f445;
sub.f32 f448, f443, f447;
add.f32 f449, f447, f443;
mul.f32 f450, f433, 0f3F4F1BBD;
sub.f32 f451, f116, f450;
fma.rn.f32 f452, f435, 0f3E9E377A, f451;
mul.f32 f453, f444, 0f3F167918;
mul.f32 f454, f446, 0f3F737871;
sub.f32 f455, f453, f454;
sub.f32 f456, f452, f455;
add.f32 f457, f455, f452;
fma.rn.f32 f458, f437, 0f3E9E377A, f133;
mul.f32 f459, f439, 0f3F4F1BBD;
sub.f32 f460, f458, f459;
sub.f32 f461, f313, f328;
mul.f32 f462, f461, 0f3F737871;
sub.f32 f463, f318, f323;
fma.rn.f32 f464, f463, 0f3F167918, f462;
add.f32 f465, f464, f460;
sub.f32 f466, f460, f464;
mul.f32 f467, f437, 0f3F4F1BBD;
sub.f32 f468, f133, f467;
fma.rn.f32 f469, f439, 0f3E9E377A, f468;
mul.f32 f470, f461, 0f3F167918;
mul.f32 f471, f463, 0f3F737871;
sub.f32 f472, f470, f471;
add.f32 f473, f472, f469;
sub.f32 f474, f469, f472;
add.f32 f475, f333, f348;
add.f32 f476, f124, f475;
add.f32 f477, f338, f343;
add.f32 f478, f477, f476;
add.f32 f479, f335, f350;
add.f32 f480, f141, f479;
add.f32 f481, f340, f345;
add.f32 f482, f481, f480;
fma.rn.f32 f483, f475, 0f3E9E377A, f124;
mul.f32 f484, f477, 0f3F4F1BBD;
sub.f32 f485, f483, f484;
sub.f32 f486, f335, f350;
mul.f32 f487, f486, 0f3F737871;
sub.f32 f488, f340, f345;
fma.rn.f32 f489, f488, 0f3F167918, f487;
sub.f32 f490, f485, f489;
add.f32 f491, f489, f485;
mul.f32 f492, f475, 0f3F4F1BBD;
sub.f32 f493, f124, f492;
fma.rn.f32 f494, f477, 0f3E9E377A, f493;
mul.f32 f495, f486, 0f3F167918;
mul.f32 f496, f488, 0f3F737871;
sub.f32 f497, f495, f496;
sub.f32 f498, f494, f497;
add.f32 f499, f497, f494;
fma.rn.f32 f500, f479, 0f3E9E377A, f141;
mul.f32 f501, f481, 0f3F4F1BBD;
sub.f32 f502, f500, f501;
sub.f32 f503, f333, f348;
mul.f32 f504, f503, 0f3F737871;
sub.f32 f505, f338, f343;
fma.rn.f32 f506, f505, 0f3F167918, f504;
add.f32 f507, f506, f502;
sub.f32 f508, f502, f506;
mul.f32 f509, f479, 0f3F4F1BBD;
sub.f32 f510, f141, f509;
fma.rn.f32 f511, f481, 0f3E9E377A, f510;
mul.f32 f512, f503, 0f3F167918;
mul.f32 f513, f505, 0f3F737871;
sub.f32 f514, f512, f513;
add.f32 f515, f514, f511;
sub.f32 f516, f511, f514;
add.f32 f517, f353, f368;
add.f32 f518, f125, f517;
add.f32 f519, f358, f363;
add.f32 f520, f519, f518;
add.f32 f521, f355, f370;
add.f32 f522, f142, f521;
add.f32 f523, f360, f365;
add.f32 f524, f523, f522;
fma.rn.f32 f525, f517, 0f3E9E377A, f125;
mul.f32 f526, f519, 0f3F4F1BBD;
sub.f32 f527, f525, f526;
sub.f32 f528, f355, f370;
mul.f32 f529, f528, 0f3F737871;
sub.f32 f530, f360, f365;
fma.rn.f32 f531, f530, 0f3F167918, f529;
sub.f32 f532, f527, f531;
add.f32 f533, f531, f527;
mul.f32 f534, f517, 0f3F4F1BBD;
sub.f32 f535, f125, f534;
fma.rn.f32 f536, f519, 0f3E9E377A, f535;
mul.f32 f537, f528, 0f3F167918;
mul.f32 f538, f530, 0f3F737871;
sub.f32 f539, f537, f538;
sub.f32 f540, f536, f539;
add.f32 f541, f539, f536;
fma.rn.f32 f542, f521, 0f3E9E377A, f142;
mul.f32 f543, f523, 0f3F4F1BBD;
sub.f32 f544, f542, f543;
sub.f32 f545, f353, f368;
mul.f32 f546, f545, 0f3F737871;
sub.f32 f547, f358, f363;
fma.rn.f32 f548, f547, 0f3F167918, f546;
add.f32 f549, f548, f544;
sub.f32 f550, f544, f548;
mul.f32 f551, f521, 0f3F4F1BBD;
sub.f32 f552, f142, f551;
fma.rn.f32 f553, f523, 0f3E9E377A, f552;
mul.f32 f554, f545, 0f3F167918;
mul.f32 f555, f547, 0f3F737871;
sub.f32 f556, f554, f555;
add.f32 f557, f556, f553;
sub.f32 f558, f553, f556;
add.f32 f559, f373, f388;
add.f32 f560, f117, f559;
add.f32 f561, f378, f383;
add.f32 f562, f561, f560;
add.f32 f563, f375, f390;
add.f32 f564, f134, f563;
add.f32 f565, f380, f385;
add.f32 f566, f565, f564;
fma.rn.f32 f567, f559, 0f3E9E377A, f117;
mul.f32 f568, f561, 0f3F4F1BBD;
sub.f32 f569, f567, f568;
sub.f32 f570, f375, f390;
mul.f32 f571, f570, 0f3F737871;
sub.f32 f572, f380, f385;
fma.rn.f32 f573, f572, 0f3F167918, f571;
sub.f32 f574, f569, f573;
add.f32 f575, f573, f569;
mul.f32 f576, f559, 0f3F4F1BBD;
sub.f32 f577, f117, f576;
fma.rn.f32 f578, f561, 0f3E9E377A, f577;
mul.f32 f579, f570, 0f3F167918;
mul.f32 f580, f572, 0f3F737871;
sub.f32 f581, f579, f580;
sub.f32 f582, f578, f581;
add.f32 f583, f581, f578;
fma.rn.f32 f584, f563, 0f3E9E377A, f134;
mul.f32 f585, f565, 0f3F4F1BBD;
sub.f32 f586, f584, f585;
sub.f32 f587, f373, f388;
mul.f32 f588, f587, 0f3F737871;
sub.f32 f589, f378, f383;
fma.rn.f32 f590, f589, 0f3F167918, f588;
add.f32 f591, f590, f586;
sub.f32 f592, f586, f590;
mul.f32 f593, f563, 0f3F4F1BBD;
sub.f32 f594, f134, f593;
fma.rn.f32 f595, f565, 0f3E9E377A, f594;
mul.f32 f596, f587, 0f3F167918;
mul.f32 f597, f589, 0f3F737871;
sub.f32 f598, f596, f597;
add.f32 f599, f598, f595;
sub.f32 f600, f595, f598;
mul.wide.u32 rd2, r4, -858993459;
shr.u64 rd3, rd2, 34;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 5;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %51;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f601, f602}, [rd6];
mul.f32 f605, f440, f602;
fma.rn.f32 f606, f601, f436, f605;
mul.f32 f607, f436, f602;
mul.f32 f608, f601, f440;
sub.f32 f609, f608, f607;
mul.f32 f610, f601, f601;
mul.f32 f611, f602, f602;
sub.f32 f612, f610, f611;
mul.f32 f613, f602, f601;
fma.rn.f32 f614, f602, f601, f613;
mul.f32 f615, f482, f614;
fma.rn.f32 f616, f612, f478, f615;
mul.f32 f617, f478, f614;
mul.f32 f618, f612, f482;
sub.f32 f619, f618, f617;
mul.f32 f620, f601, f612;
mul.f32 f621, f602, f614;
sub.f32 f622, f620, f621;
mul.f32 f623, f601, f614;
fma.rn.f32 f624, f602, f612, f623;
mul.f32 f625, f524, f624;
fma.rn.f32 f626, f622, f520, f625;
mul.f32 f627, f520, f624;
mul.f32 f628, f622, f524;
sub.f32 f629, f628, f627;
mul.f32 f630, f601, f622;
mul.f32 f631, f602, f624;
sub.f32 f632, f630, f631;
mul.f32 f633, f601, f624;
fma.rn.f32 f634, f602, f622, f633;
mul.f32 f635, f566, f634;
fma.rn.f32 f636, f632, f562, f635;
mul.f32 f637, f562, f634;
mul.f32 f638, f632, f566;
sub.f32 f639, f638, f637;
mul.f32 f640, f601, f632;
mul.f32 f641, f602, f634;
sub.f32 f642, f640, f641;
mul.f32 f643, f601, f634;
fma.rn.f32 f644, f602, f632, f643;
mul.f32 f645, f423, f644;
fma.rn.f32 f646, f642, f406, f645;
mul.f32 f647, f406, f644;
mul.f32 f648, f642, f423;
sub.f32 f649, f648, f647;
mul.f32 f650, f601, f642;
mul.f32 f651, f602, f644;
sub.f32 f652, f650, f651;
mul.f32 f653, f601, f644;
fma.rn.f32 f654, f602, f642, f653;
mul.f32 f655, f465, f654;
fma.rn.f32 f656, f652, f448, f655;
mul.f32 f657, f448, f654;
mul.f32 f658, f652, f465;
sub.f32 f659, f658, f657;
mul.f32 f660, f601, f652;
mul.f32 f661, f602, f654;
sub.f32 f662, f660, f661;
mul.f32 f663, f601, f654;
fma.rn.f32 f664, f602, f652, f663;
mul.f32 f665, f507, f664;
fma.rn.f32 f666, f662, f490, f665;
mul.f32 f667, f490, f664;
mul.f32 f668, f662, f507;
sub.f32 f669, f668, f667;
mul.f32 f670, f601, f662;
mul.f32 f671, f602, f664;
sub.f32 f672, f670, f671;
mul.f32 f673, f601, f664;
fma.rn.f32 f674, f602, f662, f673;
mul.f32 f675, f549, f674;
fma.rn.f32 f676, f672, f532, f675;
mul.f32 f677, f532, f674;
mul.f32 f678, f672, f549;
sub.f32 f679, f678, f677;
mul.f32 f680, f601, f672;
mul.f32 f681, f602, f674;
sub.f32 f682, f680, f681;
mul.f32 f683, f601, f674;
fma.rn.f32 f684, f602, f672, f683;
mul.f32 f685, f591, f684;
fma.rn.f32 f686, f682, f574, f685;
mul.f32 f687, f574, f684;
mul.f32 f688, f682, f591;
sub.f32 f689, f688, f687;
mul.f32 f690, f601, f682;
mul.f32 f691, f602, f684;
sub.f32 f692, f690, f691;
mul.f32 f693, f601, f684;
fma.rn.f32 f694, f602, f682, f693;
mul.f32 f695, f431, f694;
fma.rn.f32 f696, f692, f414, f695;
mul.f32 f697, f414, f694;
mul.f32 f698, f692, f431;
sub.f32 f699, f698, f697;
mul.f32 f700, f601, f692;
mul.f32 f701, f602, f694;
sub.f32 f702, f700, f701;
mul.f32 f703, f601, f694;
fma.rn.f32 f704, f602, f692, f703;
mul.f32 f705, f473, f704;
fma.rn.f32 f706, f702, f456, f705;
mul.f32 f707, f456, f704;
mul.f32 f708, f702, f473;
sub.f32 f709, f708, f707;
mul.f32 f710, f601, f702;
mul.f32 f711, f602, f704;
sub.f32 f712, f710, f711;
mul.f32 f713, f601, f704;
fma.rn.f32 f714, f602, f702, f713;
mul.f32 f715, f515, f714;
fma.rn.f32 f716, f712, f498, f715;
mul.f32 f717, f498, f714;
mul.f32 f718, f712, f515;
sub.f32 f719, f718, f717;
mul.f32 f720, f601, f712;
mul.f32 f721, f602, f714;
sub.f32 f722, f720, f721;
mul.f32 f723, f601, f714;
fma.rn.f32 f724, f602, f712, f723;
mul.f32 f725, f557, f724;
fma.rn.f32 f726, f722, f540, f725;
mul.f32 f727, f540, f724;
mul.f32 f728, f722, f557;
sub.f32 f729, f728, f727;
mul.f32 f730, f601, f722;
mul.f32 f731, f602, f724;
sub.f32 f732, f730, f731;
mul.f32 f733, f601, f724;
fma.rn.f32 f734, f602, f722, f733;
mul.f32 f735, f599, f734;
fma.rn.f32 f736, f732, f582, f735;
mul.f32 f737, f582, f734;
mul.f32 f738, f732, f599;
sub.f32 f739, f738, f737;
mul.f32 f740, f601, f732;
mul.f32 f741, f602, f734;
sub.f32 f742, f740, f741;
mul.f32 f743, f601, f734;
fma.rn.f32 f744, f602, f732, f743;
mul.f32 f745, f432, f744;
fma.rn.f32 f746, f742, f415, f745;
mul.f32 f747, f415, f744;
mul.f32 f748, f742, f432;
sub.f32 f749, f748, f747;
mul.f32 f750, f601, f742;
mul.f32 f751, f602, f744;
sub.f32 f752, f750, f751;
mul.f32 f753, f601, f744;
fma.rn.f32 f754, f602, f742, f753;
mul.f32 f755, f474, f754;
fma.rn.f32 f756, f752, f457, f755;
mul.f32 f757, f457, f754;
mul.f32 f758, f752, f474;
sub.f32 f759, f758, f757;
mul.f32 f760, f601, f752;
mul.f32 f761, f602, f754;
sub.f32 f762, f760, f761;
mul.f32 f763, f601, f754;
fma.rn.f32 f764, f602, f752, f763;
mul.f32 f765, f516, f764;
fma.rn.f32 f766, f762, f499, f765;
mul.f32 f767, f499, f764;
mul.f32 f768, f762, f516;
sub.f32 f769, f768, f767;
mul.f32 f770, f601, f762;
mul.f32 f771, f602, f764;
sub.f32 f772, f770, f771;
mul.f32 f773, f601, f764;
fma.rn.f32 f774, f602, f762, f773;
mul.f32 f775, f558, f774;
fma.rn.f32 f776, f772, f541, f775;
mul.f32 f777, f541, f774;
mul.f32 f778, f772, f558;
sub.f32 f779, f778, f777;
mul.f32 f780, f601, f772;
mul.f32 f781, f602, f774;
sub.f32 f782, f780, f781;
mul.f32 f783, f601, f774;
fma.rn.f32 f784, f602, f772, f783;
mul.f32 f785, f600, f784;
fma.rn.f32 f786, f782, f583, f785;
mul.f32 f787, f583, f784;
mul.f32 f788, f782, f600;
sub.f32 f789, f788, f787;
mul.f32 f790, f601, f782;
mul.f32 f791, f602, f784;
sub.f32 f792, f790, f791;
mul.f32 f793, f601, f784;
fma.rn.f32 f794, f602, f782, f793;
mul.f32 f795, f424, f794;
fma.rn.f32 f796, f792, f407, f795;
mul.f32 f797, f407, f794;
mul.f32 f798, f792, f424;
sub.f32 f799, f798, f797;
mul.f32 f800, f601, f792;
mul.f32 f801, f602, f794;
sub.f32 f802, f800, f801;
mul.f32 f803, f601, f794;
fma.rn.f32 f804, f602, f792, f803;
mul.f32 f805, f466, f804;
fma.rn.f32 f806, f802, f449, f805;
mul.f32 f807, f449, f804;
mul.f32 f808, f802, f466;
sub.f32 f809, f808, f807;
mul.f32 f810, f601, f802;
mul.f32 f811, f602, f804;
sub.f32 f812, f810, f811;
mul.f32 f813, f601, f804;
fma.rn.f32 f814, f602, f802, f813;
mul.f32 f815, f508, f814;
fma.rn.f32 f816, f812, f491, f815;
mul.f32 f817, f491, f814;
mul.f32 f818, f812, f508;
sub.f32 f819, f818, f817;
mul.f32 f820, f601, f812;
mul.f32 f821, f602, f814;
sub.f32 f822, f820, f821;
mul.f32 f823, f601, f814;
fma.rn.f32 f824, f602, f812, f823;
mul.f32 f825, f550, f824;
fma.rn.f32 f826, f822, f533, f825;
mul.f32 f827, f533, f824;
mul.f32 f828, f822, f550;
sub.f32 f829, f828, f827;
mul.f32 f830, f601, f822;
mul.f32 f831, f602, f824;
sub.f32 f832, f830, f831;
mul.f32 f833, f601, f824;
fma.rn.f32 f834, f602, f822, f833;
mul.f32 f835, f592, f834;
fma.rn.f32 f836, f832, f575, f835;
mul.f32 f837, f575, f834;
mul.f32 f838, f832, f592;
sub.f32 f839, f838, f837;
mad.lo.s32 r8, r5, 500, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 100, r8;
st.shared.f32 [r9], f394;
st.shared.f32 [r9+4], f606;
st.shared.f32 [r9+8], f616;
st.shared.f32 [r9+12], f626;
st.shared.f32 [r9+16], f636;
st.shared.f32 [r9+20], f646;
st.shared.f32 [r9+24], f656;
st.shared.f32 [r9+28], f666;
st.shared.f32 [r9+32], f676;
st.shared.f32 [r9+36], f686;
st.shared.f32 [r9+40], f696;
st.shared.f32 [r9+44], f706;
st.shared.f32 [r9+48], f716;
st.shared.f32 [r9+52], f726;
st.shared.f32 [r9+56], f736;
st.shared.f32 [r9+60], f746;
st.shared.f32 [r9+64], f756;
st.shared.f32 [r9+68], f766;
st.shared.f32 [r9+72], f776;
st.shared.f32 [r9+76], f786;
st.shared.f32 [r9+80], f796;
st.shared.f32 [r9+84], f806;
st.shared.f32 [r9+88], f816;
st.shared.f32 [r9+92], f826;
st.shared.f32 [r9+96], f836;
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.f32 f840, [r10];
ld.shared.f32 f841, [r10+20];
ld.shared.f32 f842, [r10+40];
ld.shared.f32 f843, [r10+60];
ld.shared.f32 f844, [r10+80];
ld.shared.f32 f845, [r10+100];
ld.shared.f32 f846, [r10+120];
ld.shared.f32 f847, [r10+140];
ld.shared.f32 f848, [r10+160];
ld.shared.f32 f849, [r10+180];
ld.shared.f32 f850, [r10+200];
ld.shared.f32 f851, [r10+220];
ld.shared.f32 f852, [r10+240];
ld.shared.f32 f853, [r10+260];
ld.shared.f32 f854, [r10+280];
ld.shared.f32 f855, [r10+300];
ld.shared.f32 f856, [r10+320];
ld.shared.f32 f857, [r10+340];
ld.shared.f32 f858, [r10+360];
ld.shared.f32 f859, [r10+380];
ld.shared.f32 f860, [r10+400];
ld.shared.f32 f861, [r10+420];
ld.shared.f32 f862, [r10+440];
ld.shared.f32 f863, [r10+460];
ld.shared.f32 f864, [r10+480];
barrier.sync 0;
st.shared.f32 [r9], f398;
st.shared.f32 [r9+4], f609;
st.shared.f32 [r9+8], f619;
st.shared.f32 [r9+12], f629;
st.shared.f32 [r9+16], f639;
st.shared.f32 [r9+20], f649;
st.shared.f32 [r9+24], f659;
st.shared.f32 [r9+28], f669;
st.shared.f32 [r9+32], f679;
st.shared.f32 [r9+36], f689;
st.shared.f32 [r9+40], f699;
st.shared.f32 [r9+44], f709;
st.shared.f32 [r9+48], f719;
st.shared.f32 [r9+52], f729;
st.shared.f32 [r9+56], f739;
st.shared.f32 [r9+60], f749;
st.shared.f32 [r9+64], f759;
st.shared.f32 [r9+68], f769;
st.shared.f32 [r9+72], f779;
st.shared.f32 [r9+76], f789;
st.shared.f32 [r9+80], f799;
st.shared.f32 [r9+84], f809;
st.shared.f32 [r9+88], f819;
st.shared.f32 [r9+92], f829;
st.shared.f32 [r9+96], f839;
barrier.sync 0;
ld.shared.f32 f865, [r10];
ld.shared.f32 f866, [r10+20];
ld.shared.f32 f867, [r10+40];
ld.shared.f32 f868, [r10+60];
ld.shared.f32 f869, [r10+80];
ld.shared.f32 f870, [r10+100];
ld.shared.f32 f871, [r10+120];
ld.shared.f32 f872, [r10+140];
ld.shared.f32 f873, [r10+160];
ld.shared.f32 f874, [r10+180];
ld.shared.f32 f875, [r10+200];
ld.shared.f32 f876, [r10+220];
ld.shared.f32 f877, [r10+240];
ld.shared.f32 f878, [r10+260];
ld.shared.f32 f879, [r10+280];
ld.shared.f32 f880, [r10+300];
ld.shared.f32 f881, [r10+320];
ld.shared.f32 f882, [r10+340];
ld.shared.f32 f883, [r10+360];
ld.shared.f32 f884, [r10+380];
ld.shared.f32 f885, [r10+400];
ld.shared.f32 f886, [r10+420];
ld.shared.f32 f887, [r10+440];
ld.shared.f32 f888, [r10+460];
ld.shared.f32 f889, [r10+480];
add.f32 f890, f845, f860;
add.f32 f891, f840, f890;
add.f32 f892, f850, f855;
add.f32 f893, f870, f885;
add.f32 f894, f865, f893;
add.f32 f895, f875, f880;
fma.rn.f32 f896, f890, 0f3E9E377A, f840;
mul.f32 f897, f892, 0f3F4F1BBD;
sub.f32 f898, f896, f897;
sub.f32 f899, f870, f885;
mul.f32 f900, f899, 0f3F737871;
sub.f32 f901, f875, f880;
fma.rn.f32 f902, f901, 0f3F167918, f900;
mul.f32 f903, f890, 0f3F4F1BBD;
sub.f32 f904, f840, f903;
fma.rn.f32 f905, f892, 0f3E9E377A, f904;
mul.f32 f906, f899, 0f3F167918;
mul.f32 f907, f901, 0f3F737871;
sub.f32 f908, f906, f907;
fma.rn.f32 f909, f893, 0f3E9E377A, f865;
mul.f32 f910, f895, 0f3F4F1BBD;
sub.f32 f911, f909, f910;
sub.f32 f912, f845, f860;
mul.f32 f913, f912, 0f3F737871;
sub.f32 f914, f850, f855;
fma.rn.f32 f915, f914, 0f3F167918, f913;
mul.f32 f916, f893, 0f3F4F1BBD;
sub.f32 f917, f865, f916;
fma.rn.f32 f918, f895, 0f3E9E377A, f917;
mul.f32 f919, f912, 0f3F167918;
mul.f32 f920, f914, 0f3F737871;
sub.f32 f921, f919, f920;
add.f32 f922, f846, f861;
add.f32 f923, f841, f922;
add.f32 f924, f851, f856;
add.f32 f925, f871, f886;
add.f32 f926, f866, f925;
add.f32 f927, f876, f881;
fma.rn.f32 f928, f922, 0f3E9E377A, f841;
mul.f32 f929, f924, 0f3F4F1BBD;
sub.f32 f930, f928, f929;
sub.f32 f931, f871, f886;
mul.f32 f932, f931, 0f3F737871;
sub.f32 f933, f876, f881;
fma.rn.f32 f934, f933, 0f3F167918, f932;
mul.f32 f935, f922, 0f3F4F1BBD;
sub.f32 f936, f841, f935;
fma.rn.f32 f937, f924, 0f3E9E377A, f936;
mul.f32 f938, f931, 0f3F167918;
mul.f32 f939, f933, 0f3F737871;
sub.f32 f940, f938, f939;
fma.rn.f32 f941, f925, 0f3E9E377A, f866;
mul.f32 f942, f927, 0f3F4F1BBD;
sub.f32 f943, f941, f942;
sub.f32 f944, f846, f861;
mul.f32 f945, f944, 0f3F737871;
sub.f32 f946, f851, f856;
fma.rn.f32 f947, f946, 0f3F167918, f945;
mul.f32 f948, f925, 0f3F4F1BBD;
sub.f32 f949, f866, f948;
fma.rn.f32 f950, f927, 0f3E9E377A, f949;
mul.f32 f951, f944, 0f3F167918;
mul.f32 f952, f946, 0f3F737871;
sub.f32 f953, f951, f952;
add.f32 f954, f847, f862;
add.f32 f955, f842, f954;
add.f32 f956, f852, f857;
add.f32 f957, f872, f887;
add.f32 f958, f867, f957;
add.f32 f959, f877, f882;
fma.rn.f32 f960, f954, 0f3E9E377A, f842;
mul.f32 f961, f956, 0f3F4F1BBD;
sub.f32 f962, f960, f961;
sub.f32 f963, f872, f887;
mul.f32 f964, f963, 0f3F737871;
sub.f32 f965, f877, f882;
fma.rn.f32 f966, f965, 0f3F167918, f964;
mul.f32 f967, f954, 0f3F4F1BBD;
sub.f32 f968, f842, f967;
fma.rn.f32 f969, f956, 0f3E9E377A, f968;
mul.f32 f970, f963, 0f3F167918;
mul.f32 f971, f965, 0f3F737871;
sub.f32 f972, f970, f971;
fma.rn.f32 f973, f957, 0f3E9E377A, f867;
mul.f32 f974, f959, 0f3F4F1BBD;
sub.f32 f975, f973, f974;
sub.f32 f976, f847, f862;
mul.f32 f977, f976, 0f3F737871;
sub.f32 f978, f852, f857;
fma.rn.f32 f979, f978, 0f3F167918, f977;
mul.f32 f980, f957, 0f3F4F1BBD;
sub.f32 f981, f867, f980;
fma.rn.f32 f982, f959, 0f3E9E377A, f981;
mul.f32 f983, f976, 0f3F167918;
mul.f32 f984, f978, 0f3F737871;
sub.f32 f985, f983, f984;
add.f32 f986, f848, f863;
add.f32 f987, f843, f986;
add.f32 f988, f853, f858;
add.f32 f989, f873, f888;
add.f32 f990, f868, f989;
add.f32 f991, f878, f883;
fma.rn.f32 f992, f986, 0f3E9E377A, f843;
mul.f32 f993, f988, 0f3F4F1BBD;
sub.f32 f994, f992, f993;
sub.f32 f995, f873, f888;
mul.f32 f996, f995, 0f3F737871;
sub.f32 f997, f878, f883;
fma.rn.f32 f998, f997, 0f3F167918, f996;
mul.f32 f999, f986, 0f3F4F1BBD;
sub.f32 f1000, f843, f999;
fma.rn.f32 f1001, f988, 0f3E9E377A, f1000;
mul.f32 f1002, f995, 0f3F167918;
mul.f32 f1003, f997, 0f3F737871;
sub.f32 f1004, f1002, f1003;
fma.rn.f32 f1005, f989, 0f3E9E377A, f868;
mul.f32 f1006, f991, 0f3F4F1BBD;
sub.f32 f1007, f1005, f1006;
sub.f32 f1008, f848, f863;
mul.f32 f1009, f1008, 0f3F737871;
sub.f32 f1010, f853, f858;
fma.rn.f32 f1011, f1010, 0f3F167918, f1009;
mul.f32 f1012, f989, 0f3F4F1BBD;
sub.f32 f1013, f868, f1012;
fma.rn.f32 f1014, f991, 0f3E9E377A, f1013;
mul.f32 f1015, f1008, 0f3F167918;
mul.f32 f1016, f1010, 0f3F737871;
sub.f32 f1017, f1015, f1016;
add.f32 f1018, f849, f864;
add.f32 f1019, f844, f1018;
add.f32 f1020, f854, f859;
add.f32 f1021, f874, f889;
add.f32 f1022, f869, f1021;
add.f32 f1023, f879, f884;
fma.rn.f32 f1024, f1018, 0f3E9E377A, f844;
mul.f32 f1025, f1020, 0f3F4F1BBD;
sub.f32 f1026, f1024, f1025;
sub.f32 f1027, f874, f889;
mul.f32 f1028, f1027, 0f3F737871;
sub.f32 f1029, f879, f884;
fma.rn.f32 f1030, f1029, 0f3F167918, f1028;
mul.f32 f1031, f1018, 0f3F4F1BBD;
sub.f32 f1032, f844, f1031;
fma.rn.f32 f1033, f1020, 0f3E9E377A, f1032;
mul.f32 f1034, f1027, 0f3F167918;
mul.f32 f1035, f1029, 0f3F737871;
sub.f32 f1036, f1034, f1035;
fma.rn.f32 f1037, f1021, 0f3E9E377A, f869;
mul.f32 f1038, f1023, 0f3F4F1BBD;
sub.f32 f1039, f1037, f1038;
sub.f32 f1040, f849, f864;
mul.f32 f1041, f1040, 0f3F737871;
sub.f32 f1042, f854, f859;
fma.rn.f32 f1043, f1042, 0f3F167918, f1041;
mul.f32 f1044, f1021, 0f3F4F1BBD;
sub.f32 f1045, f869, f1044;
fma.rn.f32 f1046, f1023, 0f3E9E377A, f1045;
mul.f32 f1047, f1040, 0f3F167918;
mul.f32 f1048, f1042, 0f3F737871;
sub.f32 f1049, f1047, f1048;
add.f32 %0, f892, f891;
add.f32 %1, f895, f894;
add.f32 %2, f924, f923;
add.f32 %3, f927, f926;
add.f32 %4, f956, f955;
add.f32 %5, f959, f958;
add.f32 %6, f988, f987;
add.f32 %7, f991, f990;
add.f32 %8, f1020, f1019;
add.f32 %9, f1023, f1022;
add.f32 %11, f915, f911;
sub.f32 %10, f898, f902;
add.f32 %13, f947, f943;
sub.f32 %12, f930, f934;
add.f32 %15, f979, f975;
sub.f32 %14, f962, f966;
add.f32 %17, f1011, f1007;
sub.f32 %16, f994, f998;
add.f32 %19, f1043, f1039;
sub.f32 %18, f1026, f1030;
sub.f32 %20, f905, f908;
add.f32 %21, f921, f918;
sub.f32 %22, f937, f940;
add.f32 %23, f953, f950;
sub.f32 %24, f969, f972;
add.f32 %25, f985, f982;
sub.f32 %26, f1001, f1004;
add.f32 %27, f1017, f1014;
sub.f32 %28, f1033, f1036;
add.f32 %29, f1049, f1046;
add.f32 %30, f908, f905;
sub.f32 %31, f918, f921;
add.f32 %32, f940, f937;
sub.f32 %33, f950, f953;
add.f32 %34, f972, f969;
sub.f32 %35, f982, f985;
add.f32 %36, f1004, f1001;
sub.f32 %37, f1014, f1017;
add.f32 %38, f1036, f1033;
sub.f32 %39, f1046, f1049;
sub.f32 %41, f911, f915;
add.f32 %40, f902, f898;
sub.f32 %43, f943, f947;
add.f32 %42, f934, f930;
sub.f32 %45, f975, f979;
add.f32 %44, f966, f962;
sub.f32 %47, f1007, f1011;
add.f32 %46, f998, f994;
sub.f32 %49, f1039, f1043;
add.f32 %48, f1030, f1026;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_125), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<362, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<265>;
.reg .b32 r<18>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 1000, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %15, %23;
add.f32 f22, %13, f21;
add.f32 f23, %18, %21;
add.f32 f24, %17, %24;
add.f32 f25, %14, f24;
add.f32 f26, %20, %22;
fma.rn.f32 f27, f21, 0f3E9E377A, %13;
mul.f32 f28, f23, 0f3F4F1BBD;
sub.f32 f29, f27, f28;
sub.f32 f30, %17, %24;
mul.f32 f31, f30, 0f3F737871;
sub.f32 f32, %20, %22;
fma.rn.f32 f33, f32, 0f3F167918, f31;
sub.f32 f34, f29, f33;
add.f32 f35, f33, f29;
mul.f32 f36, f21, 0f3F4F1BBD;
sub.f32 f37, %13, f36;
fma.rn.f32 f38, f23, 0f3E9E377A, f37;
mul.f32 f39, f30, 0f3F167918;
mul.f32 f40, f32, 0f3F737871;
sub.f32 f41, f39, f40;
sub.f32 f42, f38, f41;
add.f32 f43, f41, f38;
fma.rn.f32 f44, f24, 0f3E9E377A, %14;
mul.f32 f45, f26, 0f3F4F1BBD;
sub.f32 f46, f44, f45;
sub.f32 f47, %15, %23;
mul.f32 f48, f47, 0f3F737871;
sub.f32 f49, %18, %21;
fma.rn.f32 f50, f49, 0f3F167918, f48;
add.f32 f51, f50, f46;
sub.f32 f52, f46, f50;
mul.f32 f53, f24, 0f3F4F1BBD;
sub.f32 f54, %14, f53;
fma.rn.f32 f55, f26, 0f3E9E377A, f54;
mul.f32 f56, f47, 0f3F167918;
mul.f32 f57, f49, 0f3F737871;
sub.f32 f58, f56, f57;
add.f32 f59, f58, f55;
sub.f32 f60, f55, f58;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 1000, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f61, f62}, [rd6];
mul.f32 f65, f51, f62;
mul.f32 f66, f34, f62;
mul.f32 f67, f61, f51;
mul.f32 f68, f61, f61;
mul.f32 f69, f62, f62;
sub.f32 f70, f68, f69;
mul.f32 f71, f62, f61;
fma.rn.f32 f72, f62, f61, f71;
mul.f32 f73, f59, f72;
mul.f32 f74, f42, f72;
mul.f32 f75, f70, f59;
mul.f32 f76, f61, f70;
mul.f32 f77, f62, f72;
sub.f32 f78, f76, f77;
mul.f32 f79, f61, f72;
fma.rn.f32 f80, f62, f70, f79;
mul.f32 f81, f60, f80;
mul.f32 f82, f43, f80;
mul.f32 f83, f78, f60;
mul.f32 f84, f61, f78;
mul.f32 f85, f62, f80;
sub.f32 f86, f84, f85;
mul.f32 f87, f61, f80;
fma.rn.f32 f88, f62, f78, f87;
mul.f32 f89, f52, f88;
mul.f32 f90, f35, f88;
mul.f32 f91, f86, f52;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
add.f32 f92, f26, f25;
add.f32 f93, f23, f22;
st.shared.v2.f32 [r9], {f93, f92};
fma.rn.f32 f94, f61, f34, f65;
sub.f32 f95, f67, f66;
st.shared.v2.f32 [r9+8], {f94, f95};
fma.rn.f32 f96, f70, f42, f73;
sub.f32 f97, f75, f74;
st.shared.v2.f32 [r9+16], {f96, f97};
sub.f32 f98, f83, f82;
fma.rn.f32 f99, f78, f43, f81;
st.shared.v2.f32 [r9+24], {f99, f98};
fma.rn.f32 f100, f86, f35, f89;
sub.f32 f101, f91, f90;
st.shared.v2.f32 [r9+32], {f100, f101};
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f102, f103}, [r11];
ld.shared.v2.f32 {f106, f107}, [r11+200];
ld.shared.v2.f32 {f110, f111}, [r11+400];
ld.shared.v2.f32 {f114, f115}, [r11+600];
ld.shared.v2.f32 {f118, f119}, [r11+800];
add.f32 f122, f106, f118;
add.f32 f123, f102, f122;
add.f32 f124, f110, f114;
add.f32 f125, f107, f119;
add.f32 f126, f103, f125;
add.f32 f127, f111, f115;
fma.rn.f32 f128, f122, 0f3E9E377A, f102;
mul.f32 f129, f124, 0f3F4F1BBD;
sub.f32 f130, f128, f129;
sub.f32 f131, f107, f119;
mul.f32 f132, f131, 0f3F737871;
sub.f32 f133, f111, f115;
fma.rn.f32 f134, f133, 0f3F167918, f132;
sub.f32 f135, f130, f134;
add.f32 f136, f134, f130;
mul.f32 f137, f122, 0f3F4F1BBD;
sub.f32 f138, f102, f137;
fma.rn.f32 f139, f124, 0f3E9E377A, f138;
mul.f32 f140, f131, 0f3F167918;
mul.f32 f141, f133, 0f3F737871;
sub.f32 f142, f140, f141;
sub.f32 f143, f139, f142;
add.f32 f144, f142, f139;
fma.rn.f32 f145, f125, 0f3E9E377A, f103;
mul.f32 f146, f127, 0f3F4F1BBD;
sub.f32 f147, f145, f146;
sub.f32 f148, f106, f118;
mul.f32 f149, f148, 0f3F737871;
sub.f32 f150, f110, f114;
fma.rn.f32 f151, f150, 0f3F167918, f149;
add.f32 f152, f151, f147;
sub.f32 f153, f147, f151;
mul.f32 f154, f125, 0f3F4F1BBD;
sub.f32 f155, f103, f154;
fma.rn.f32 f156, f127, 0f3E9E377A, f155;
mul.f32 f157, f148, 0f3F167918;
mul.f32 f158, f150, 0f3F737871;
sub.f32 f159, f157, f158;
add.f32 f160, f159, f156;
sub.f32 f161, f156, f159;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f162, f163}, [rd11];
mul.f32 f166, f152, f163;
mul.f32 f167, f135, f163;
mul.f32 f168, f162, f152;
mul.f32 f169, f162, f162;
mul.f32 f170, f163, f163;
sub.f32 f171, f169, f170;
mul.f32 f172, f163, f162;
fma.rn.f32 f173, f163, f162, f172;
mul.f32 f174, f160, f173;
mul.f32 f175, f143, f173;
mul.f32 f176, f171, f160;
mul.f32 f177, f162, f171;
mul.f32 f178, f163, f173;
sub.f32 f179, f177, f178;
mul.f32 f180, f162, f173;
fma.rn.f32 f181, f163, f171, f180;
mul.f32 f182, f161, f181;
mul.f32 f183, f144, f181;
mul.f32 f184, f179, f161;
mul.f32 f185, f162, f179;
mul.f32 f186, f163, f181;
sub.f32 f187, f185, f186;
mul.f32 f188, f162, f181;
fma.rn.f32 f189, f163, f179, f188;
mul.f32 f190, f153, f189;
mul.f32 f191, f136, f189;
mul.f32 f192, f187, f153;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 200, r16;
add.f32 f193, f127, f126;
add.f32 f194, f124, f123;
st.shared.v2.f32 [r17], {f194, f193};
fma.rn.f32 f195, f162, f135, f166;
sub.f32 f196, f168, f167;
st.shared.v2.f32 [r17+40], {f195, f196};
fma.rn.f32 f197, f171, f143, f174;
sub.f32 f198, f176, f175;
st.shared.v2.f32 [r17+80], {f197, f198};
fma.rn.f32 f199, f179, f144, f182;
sub.f32 f200, f184, f183;
st.shared.v2.f32 [r17+120], {f199, f200};
fma.rn.f32 f201, f187, f136, f190;
sub.f32 f202, f192, f191;
st.shared.v2.f32 [r17+160], {f201, f202};
barrier.sync 0;
ld.shared.v2.f32 {f203, f204}, [r11];
ld.shared.v2.f32 {f207, f208}, [r11+200];
ld.shared.v2.f32 {f211, f212}, [r11+400];
ld.shared.v2.f32 {f215, f216}, [r11+600];
ld.shared.v2.f32 {f219, f220}, [r11+800];
add.f32 f223, f207, f219;
add.f32 f224, f203, f223;
add.f32 f225, f211, f215;
add.f32 f226, f208, f220;
add.f32 f227, f204, f226;
add.f32 f228, f212, f216;
fma.rn.f32 f229, f223, 0f3E9E377A, f203;
mul.f32 f230, f225, 0f3F4F1BBD;
sub.f32 f231, f229, f230;
sub.f32 f232, f208, f220;
mul.f32 f233, f232, 0f3F737871;
sub.f32 f234, f212, f216;
fma.rn.f32 f235, f234, 0f3F167918, f233;
mul.f32 f236, f223, 0f3F4F1BBD;
sub.f32 f237, f203, f236;
fma.rn.f32 f238, f225, 0f3E9E377A, f237;
mul.f32 f239, f232, 0f3F167918;
mul.f32 f240, f234, 0f3F737871;
sub.f32 f241, f239, f240;
fma.rn.f32 f242, f226, 0f3E9E377A, f204;
mul.f32 f243, f228, 0f3F4F1BBD;
sub.f32 f244, f242, f243;
sub.f32 f245, f207, f219;
mul.f32 f246, f245, 0f3F737871;
sub.f32 f247, f211, f215;
fma.rn.f32 f248, f247, 0f3F167918, f246;
mul.f32 f249, f226, 0f3F4F1BBD;
sub.f32 f250, f204, f249;
fma.rn.f32 f251, f228, 0f3E9E377A, f250;
mul.f32 f252, f245, 0f3F167918;
mul.f32 f253, f247, 0f3F737871;
sub.f32 f254, f252, f253;
add.f32 %1, f228, f227;
add.f32 %0, f225, f224;
add.f32 %3, f248, f244;
sub.f32 %2, f231, f235;
add.f32 %5, f254, f251;
sub.f32 %4, f238, f241;
sub.f32 %7, f251, f254;
add.f32 %6, f241, f238;
sub.f32 %9, f244, f248;
add.f32 %8, f235, f231;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_125), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<363, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<245>;
.reg .b32 r<18>;
.reg .b64 rd<12>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 500, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %15, %23;
add.f32 f22, %13, f21;
add.f32 f23, %18, %21;
add.f32 f24, f23, f22;
add.f32 f25, %17, %24;
add.f32 f26, %14, f25;
add.f32 f27, %20, %22;
add.f32 f28, f27, f26;
fma.rn.f32 f29, f21, 0f3E9E377A, %13;
mul.f32 f30, f23, 0f3F4F1BBD;
sub.f32 f31, f29, f30;
sub.f32 f32, %17, %24;
mul.f32 f33, f32, 0f3F737871;
sub.f32 f34, %20, %22;
fma.rn.f32 f35, f34, 0f3F167918, f33;
sub.f32 f36, f31, f35;
add.f32 f37, f35, f31;
mul.f32 f38, f21, 0f3F4F1BBD;
sub.f32 f39, %13, f38;
fma.rn.f32 f40, f23, 0f3E9E377A, f39;
mul.f32 f41, f32, 0f3F167918;
mul.f32 f42, f34, 0f3F737871;
sub.f32 f43, f41, f42;
sub.f32 f44, f40, f43;
add.f32 f45, f43, f40;
fma.rn.f32 f46, f25, 0f3E9E377A, %14;
mul.f32 f47, f27, 0f3F4F1BBD;
sub.f32 f48, f46, f47;
sub.f32 f49, %15, %23;
mul.f32 f50, f49, 0f3F737871;
sub.f32 f51, %18, %21;
fma.rn.f32 f52, f51, 0f3F167918, f50;
add.f32 f53, f52, f48;
sub.f32 f54, f48, f52;
mul.f32 f55, f25, 0f3F4F1BBD;
sub.f32 f56, %14, f55;
fma.rn.f32 f57, f27, 0f3E9E377A, f56;
mul.f32 f58, f49, 0f3F167918;
mul.f32 f59, f51, 0f3F737871;
sub.f32 f60, f58, f59;
add.f32 f61, f60, f57;
sub.f32 f62, f57, f60;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f63, f64}, [rd6];
mul.f32 f67, f53, f64;
fma.rn.f32 f68, f63, f36, f67;
mul.f32 f69, f36, f64;
mul.f32 f70, f63, f53;
sub.f32 f71, f70, f69;
mul.f32 f72, f63, f63;
mul.f32 f73, f64, f64;
sub.f32 f74, f72, f73;
mul.f32 f75, f64, f63;
fma.rn.f32 f76, f64, f63, f75;
mul.f32 f77, f61, f76;
fma.rn.f32 f78, f74, f44, f77;
mul.f32 f79, f44, f76;
mul.f32 f80, f74, f61;
sub.f32 f81, f80, f79;
mul.f32 f82, f63, f74;
mul.f32 f83, f64, f76;
sub.f32 f84, f82, f83;
mul.f32 f85, f63, f76;
fma.rn.f32 f86, f64, f74, f85;
mul.f32 f87, f62, f86;
fma.rn.f32 f88, f84, f45, f87;
mul.f32 f89, f45, f86;
mul.f32 f90, f84, f62;
sub.f32 f91, f90, f89;
mul.f32 f92, f63, f84;
mul.f32 f93, f64, f86;
sub.f32 f94, f92, f93;
mul.f32 f95, f63, f86;
fma.rn.f32 f96, f64, f84, f95;
mul.f32 f97, f54, f96;
fma.rn.f32 f98, f94, f37, f97;
mul.f32 f99, f37, f96;
mul.f32 f100, f94, f54;
sub.f32 f101, f100, f99;
mad.lo.s32 r8, r5, 500, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 20, r8;
st.shared.f32 [r9], f24;
st.shared.f32 [r9+4], f68;
st.shared.f32 [r9+8], f78;
st.shared.f32 [r9+12], f88;
st.shared.f32 [r9+16], f98;
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.f32 f102, [r11];
ld.shared.f32 f103, [r11+100];
ld.shared.f32 f104, [r11+200];
ld.shared.f32 f105, [r11+300];
ld.shared.f32 f106, [r11+400];
barrier.sync 0;
st.shared.f32 [r9], f28;
st.shared.f32 [r9+4], f71;
st.shared.f32 [r9+8], f81;
st.shared.f32 [r9+12], f91;
st.shared.f32 [r9+16], f101;
barrier.sync 0;
ld.shared.f32 f107, [r11];
ld.shared.f32 f108, [r11+100];
ld.shared.f32 f109, [r11+200];
ld.shared.f32 f110, [r11+300];
ld.shared.f32 f111, [r11+400];
add.f32 f112, f103, f106;
add.f32 f113, f102, f112;
add.f32 f114, f104, f105;
add.f32 f115, f114, f113;
add.f32 f116, f108, f111;
add.f32 f117, f107, f116;
add.f32 f118, f109, f110;
add.f32 f119, f118, f117;
fma.rn.f32 f120, f112, 0f3E9E377A, f102;
mul.f32 f121, f114, 0f3F4F1BBD;
sub.f32 f122, f120, f121;
sub.f32 f123, f108, f111;
mul.f32 f124, f123, 0f3F737871;
sub.f32 f125, f109, f110;
fma.rn.f32 f126, f125, 0f3F167918, f124;
sub.f32 f127, f122, f126;
add.f32 f128, f126, f122;
mul.f32 f129, f112, 0f3F4F1BBD;
sub.f32 f130, f102, f129;
fma.rn.f32 f131, f114, 0f3E9E377A, f130;
mul.f32 f132, f123, 0f3F167918;
mul.f32 f133, f125, 0f3F737871;
sub.f32 f134, f132, f133;
sub.f32 f135, f131, f134;
add.f32 f136, f134, f131;
fma.rn.f32 f137, f116, 0f3E9E377A, f107;
mul.f32 f138, f118, 0f3F4F1BBD;
sub.f32 f139, f137, f138;
sub.f32 f140, f103, f106;
mul.f32 f141, f140, 0f3F737871;
sub.f32 f142, f104, f105;
fma.rn.f32 f143, f142, 0f3F167918, f141;
add.f32 f144, f143, f139;
sub.f32 f145, f139, f143;
mul.f32 f146, f116, 0f3F4F1BBD;
sub.f32 f147, f107, f146;
fma.rn.f32 f148, f118, 0f3E9E377A, f147;
mul.f32 f149, f140, 0f3F167918;
mul.f32 f150, f142, 0f3F737871;
sub.f32 f151, f149, f150;
add.f32 f152, f151, f148;
sub.f32 f153, f148, f151;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f154, f155}, [rd11];
mul.f32 f158, f144, f155;
fma.rn.f32 f159, f154, f127, f158;
mul.f32 f160, f127, f155;
mul.f32 f161, f154, f144;
sub.f32 f162, f161, f160;
mul.f32 f163, f154, f154;
mul.f32 f164, f155, f155;
sub.f32 f165, f163, f164;
mul.f32 f166, f155, f154;
fma.rn.f32 f167, f155, f154, f166;
mul.f32 f168, f152, f167;
fma.rn.f32 f169, f165, f135, f168;
mul.f32 f170, f135, f167;
mul.f32 f171, f165, f152;
sub.f32 f172, f171, f170;
mul.f32 f173, f154, f165;
mul.f32 f174, f155, f167;
sub.f32 f175, f173, f174;
mul.f32 f176, f154, f167;
fma.rn.f32 f177, f155, f165, f176;
mul.f32 f178, f153, f177;
fma.rn.f32 f179, f175, f136, f178;
mul.f32 f180, f136, f177;
mul.f32 f181, f175, f153;
sub.f32 f182, f181, f180;
mul.f32 f183, f154, f175;
mul.f32 f184, f155, f177;
sub.f32 f185, f183, f184;
mul.f32 f186, f154, f177;
fma.rn.f32 f187, f155, f175, f186;
mul.f32 f188, f145, f187;
fma.rn.f32 f189, f185, f128, f188;
mul.f32 f190, f128, f187;
mul.f32 f191, f185, f145;
sub.f32 f192, f191, f190;
shl.b32 r15, r14, 2;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 100, r16;
st.shared.f32 [r17], f115;
st.shared.f32 [r17+20], f159;
st.shared.f32 [r17+40], f169;
st.shared.f32 [r17+60], f179;
st.shared.f32 [r17+80], f189;
barrier.sync 0;
ld.shared.f32 f193, [r11];
ld.shared.f32 f194, [r11+100];
ld.shared.f32 f195, [r11+200];
ld.shared.f32 f196, [r11+300];
ld.shared.f32 f197, [r11+400];
barrier.sync 0;
st.shared.f32 [r17], f119;
st.shared.f32 [r17+20], f162;
st.shared.f32 [r17+40], f172;
st.shared.f32 [r17+60], f182;
st.shared.f32 [r17+80], f192;
barrier.sync 0;
ld.shared.f32 f198, [r11];
ld.shared.f32 f199, [r11+100];
ld.shared.f32 f200, [r11+200];
ld.shared.f32 f201, [r11+300];
ld.shared.f32 f202, [r11+400];
add.f32 f203, f194, f197;
add.f32 f204, f193, f203;
add.f32 f205, f195, f196;
add.f32 f206, f199, f202;
add.f32 f207, f198, f206;
add.f32 f208, f200, f201;
fma.rn.f32 f209, f203, 0f3E9E377A, f193;
mul.f32 f210, f205, 0f3F4F1BBD;
sub.f32 f211, f209, f210;
sub.f32 f212, f199, f202;
mul.f32 f213, f212, 0f3F737871;
sub.f32 f214, f200, f201;
fma.rn.f32 f215, f214, 0f3F167918, f213;
mul.f32 f216, f203, 0f3F4F1BBD;
sub.f32 f217, f193, f216;
fma.rn.f32 f218, f205, 0f3E9E377A, f217;
mul.f32 f219, f212, 0f3F167918;
mul.f32 f220, f214, 0f3F737871;
sub.f32 f221, f219, f220;
fma.rn.f32 f222, f206, 0f3E9E377A, f198;
mul.f32 f223, f208, 0f3F4F1BBD;
sub.f32 f224, f222, f223;
sub.f32 f225, f194, f197;
mul.f32 f226, f225, 0f3F737871;
sub.f32 f227, f195, f196;
fma.rn.f32 f228, f227, 0f3F167918, f226;
mul.f32 f229, f206, 0f3F4F1BBD;
sub.f32 f230, f198, f229;
fma.rn.f32 f231, f208, 0f3E9E377A, f230;
mul.f32 f232, f225, 0f3F167918;
mul.f32 f233, f227, 0f3F737871;
sub.f32 f234, f232, f233;
add.f32 %0, f205, f204;
add.f32 %1, f208, f207;
add.f32 %3, f228, f224;
sub.f32 %2, f211, f215;
sub.f32 %4, f218, f221;
add.f32 %5, f234, f231;
add.f32 %6, f221, f218;
sub.f32 %7, f231, f234;
sub.f32 %9, f224, f228;
add.f32 %8, f215, f211;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_125), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};


#endif
